/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.gui.container.WindingTableContainer;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class WindingTableTileEntity
extends InventoryTE {
    @ObjectHolder(value="winding_table")
    private static TileEntityType<WindingTableTileEntity> type = null;
    public static final double INERTIA = 50.0;
    public static final double INCREMENT = 0.2;
    private boolean redstone = false;
    private final LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());

    public WindingTableTileEntity() {
        super(type, 1);
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        if (this.inventory[0].func_77973_b() instanceof IWindableItem) {
            IWindableItem item = (IWindableItem)this.inventory[0].func_77973_b();
            double speed = item.getWindLevel(this.inventory[0]);
            double maxSpeed = item.getMaxWind();
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.winding_table.winding", new Object[]{CRConfig.formatVal(speed), CRConfig.formatVal(maxSpeed)}));
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.winding_table.power", new Object[]{CRConfig.formatVal(speed * (Double)CRConfig.windingResist.get())}));
        } else {
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.winding_table.empty", new Object[0]));
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.winding_table.power", new Object[]{0}));
        }
        super.addInfo(chat, player, hit);
    }

    @Override
    protected boolean useRotary() {
        return true;
    }

    public void redstoneTrigger(boolean reds) {
        if (reds != this.redstone) {
            this.redstone = reds;
            if (reds && this.inventory[0].func_77973_b() instanceof IWindableItem) {
                IWindableItem item = (IWindableItem)this.inventory[0].func_77973_b();
                double itemSpeed = item.getWindLevel(this.inventory[0]);
                if (itemSpeed < item.getMaxWind()) {
                    item.setWindLevel(this.inventory[0], itemSpeed += 0.2);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187776_dp, SoundCategory.BLOCKS, 1.0f, (float)Math.random());
                } else {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187774_do, SoundCategory.BLOCKS, 2.0f, (float)Math.random());
                }
            }
            this.func_70296_d();
        }
    }

    public double getStoredSpeed() {
        if (this.inventory[0].func_77973_b() instanceof IWindableItem) {
            return ((IWindableItem)this.inventory[0].func_77973_b()).getWindLevel(this.inventory[0]);
        }
        return 0.0;
    }

    public int getProgress() {
        if (this.inventory[0].func_77973_b() instanceof IWindableItem) {
            IWindableItem item = (IWindableItem)this.inventory[0].func_77973_b();
            double speed = item.getWindLevel(this.inventory[0]);
            double maxSpeed = item.getMaxWind();
            return (int)Math.round(speed / maxSpeed * 100.0);
        }
        return 0;
    }

    @Override
    public double getMoInertia() {
        return 50.0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K || !(this.inventory[0].func_77973_b() instanceof IWindableItem)) {
            return;
        }
        IWindableItem item = (IWindableItem)this.inventory[0].func_77973_b();
        double itemSpeed = item.getWindLevel(this.inventory[0]);
        if (itemSpeed > this.motData[0]) {
            this.motData[1] = this.motData[1] + 50.0 * itemSpeed * itemSpeed / 2.0;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (((Boolean)CRConfig.windingDestroy.get()).booleanValue()) {
                this.inventory[0] = ItemStack.field_190927_a;
                this.func_70296_d();
            } else {
                itemSpeed = 0.0;
                item.setWindLevel(this.inventory[0], itemSpeed);
            }
        } else {
            this.motData[1] = Math.max(this.motData[1] - (Double)CRConfig.windingResist.get() * itemSpeed, 0.0);
        }
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && stack.func_77973_b() instanceof IWindableItem;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.winding_table", new Object[0]);
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.redstone = nbt.func_74767_n("reds");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("reds", this.redstone);
        return nbt;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        if (cap == Capabilities.AXLE_CAPABILITY && (side == Direction.UP || side == null)) {
            return this.axleOpt;
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new WindingTableContainer(id, playerInv, this.createContainerBuf());
    }

    public static interface IWindableItem {
        public double getMaxWind();

        default public void setWindLevel(ItemStack stack, double energy) {
            stack.func_196082_o().func_74780_a("winding_energy", energy);
        }

        default public double getWindLevel(ItemStack stack) {
            return stack.func_196082_o().func_74769_h("winding_energy");
        }
    }
}

