/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.itemSets.GearFactory;
import com.Da_Technomancer.crossroads.render.TESR.CRModels;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.IMechanism;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.MechanismTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class MechanismAxle
implements IMechanism {
    protected static final VoxelShape[] SHAPES = new VoxelShape[3];

    @Override
    public double getInertia(GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis) {
        return MiscUtil.preciseRound(mat.getDensity() / 32000.0, 3);
    }

    @Override
    public boolean hasCap(Capability<?> cap, Direction capSide, GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis, MechanismTileEntity te) {
        return cap == Capabilities.AXLE_CAPABILITY && side == null && capSide.func_176740_k() == axis;
    }

    @Override
    public void propogate(GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis, MechanismTileEntity te, MechanismTileEntity.SidedAxleHandler handler, IAxisHandler masterIn, byte key, double rotRatioIn, double lastRadius) {
        if (side != null) {
            return;
        }
        if (rotRatioIn == 0.0) {
            rotRatioIn = 1.0;
        }
        if (key == handler.updateKey) {
            if (handler.rotRatio != rotRatioIn) {
                masterIn.lock();
            }
            return;
        }
        if (masterIn.addToList(handler)) {
            return;
        }
        handler.rotRatio = rotRatioIn;
        handler.updateKey = key;
        for (Direction.AxisDirection direct : Direction.AxisDirection.values()) {
            LazyOptional axleOpt;
            Direction endDir = Direction.func_181076_a((Direction.AxisDirection)direct, (Direction.Axis)axis);
            if (te.members[endDir.func_176745_a()] != null) {
                if (!te.members[endDir.func_176745_a()].hasCap(Capabilities.AXLE_CAPABILITY, endDir, te.mats[endDir.func_176745_a()], endDir, axis, te)) continue;
                te.axleHandlers[endDir.func_176745_a()].propogate(masterIn, key, rotRatioIn, 0.0, handler.renderOffset);
                continue;
            }
            TileEntity endTE = te.func_145831_w().func_175625_s(te.func_174877_v().func_177972_a(endDir));
            Direction oEndDir = endDir.func_176734_d();
            if (endTE == null) continue;
            LazyOptional axisOpt = endTE.getCapability(Capabilities.AXIS_CAPABILITY, oEndDir);
            if (axisOpt.isPresent()) {
                ((IAxisHandler)axisOpt.orElseThrow(NullPointerException::new)).trigger(masterIn, key);
            }
            if (!(axleOpt = endTE.getCapability(Capabilities.AXLE_CAPABILITY, oEndDir)).isPresent()) continue;
            ((IAxleHandler)axleOpt.orElseThrow(NullPointerException::new)).propogate(masterIn, key, handler.rotRatio, 0.0, handler.renderOffset);
        }
    }

    @Override
    @Nonnull
    public ItemStack getDrop(GearFactory.GearMaterial mat) {
        return CRItems.axle.withMaterial(mat, 1);
    }

    @Override
    public VoxelShape getBoundingBox(@Nullable Direction side, @Nullable Direction.Axis axis) {
        return side != null || axis == null ? VoxelShapes.func_197880_a() : SHAPES[axis.ordinal()];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(MechanismTileEntity te, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, float partialTicks, GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis) {
        if (axis == null) {
            return;
        }
        MechanismTileEntity.SidedAxleHandler handler = te.axleHandlers[6];
        if (axis != Direction.Axis.Y) {
            Quaternion rotation = (axis == Direction.Axis.X ? Vector3f.field_229182_e_ : Vector3f.field_229179_b_).func_229187_a_(90.0f);
            matrix.func_227863_a_(rotation);
        }
        float angle = handler.getAngle(partialTicks);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        CRModels.drawAxle(matrix, buffer, combinedLight, mat.getColor());
    }

    static {
        MechanismAxle.SHAPES[0] = Block.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
        MechanismAxle.SHAPES[1] = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
        MechanismAxle.SHAPES[2] = Block.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0);
    }
}

