/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.itemSets.GearFactory;
import com.Da_Technomancer.crossroads.render.CRRenderTypes;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.render.TESR.CRModels;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.MechanismAxle;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.MechanismTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class MechanismClutch
extends MechanismAxle {
    private final boolean inverted;
    private static final VoxelShape[] SHAPES_CLUTCH = new VoxelShape[3];

    public MechanismClutch(boolean inverted) {
        this.inverted = inverted;
    }

    @Override
    public void onRedstoneChange(double prevValue, double newValue, GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis, double[] motData, MechanismTileEntity te) {
        if (newValue == 0.0 ^ prevValue == 0.0) {
            te.func_145831_w().func_184133_a(null, te.func_174877_v(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, newValue != 0.0 ^ this.inverted ? 0.6f : 0.5f);
            RotaryUtil.increaseMasterKey(true);
        }
    }

    @Override
    public double getCircuitSignal(GearFactory.GearMaterial mat, Direction.Axis axis, double[] motData, MechanismTileEntity te) {
        return Math.abs(motData[0]);
    }

    @Override
    public boolean hasCap(Capability<?> cap, Direction capSide, GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis, MechanismTileEntity te) {
        return cap == Capabilities.AXLE_CAPABILITY && side == null && capSide.func_176740_k() == axis && (te.redstoneIn != 0 ^ this.inverted || capSide.func_176743_c() == Direction.AxisDirection.NEGATIVE);
    }

    @Override
    public void propogate(GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis, MechanismTileEntity te, MechanismTileEntity.SidedAxleHandler handler, IAxisHandler masterIn, byte key, double rotRatioIn, double lastRadius) {
        if (side != null) {
            return;
        }
        if (rotRatioIn == 0.0) {
            rotRatioIn = 1.0;
        }
        if (key == handler.updateKey) {
            if (handler.rotRatio != rotRatioIn) {
                masterIn.lock();
            }
            return;
        }
        if (masterIn.addToList(handler)) {
            return;
        }
        handler.rotRatio = rotRatioIn;
        handler.updateKey = key;
        for (Direction.AxisDirection direct : Direction.AxisDirection.values()) {
            LazyOptional axleOpt;
            if (direct == Direction.AxisDirection.POSITIVE && te.redstoneIn == 0 ^ this.inverted) continue;
            Direction endDir = Direction.func_181076_a((Direction.AxisDirection)direct, (Direction.Axis)axis);
            if (te.members[endDir.func_176745_a()] != null) {
                if (!te.members[endDir.func_176745_a()].hasCap(Capabilities.AXLE_CAPABILITY, endDir, te.mats[endDir.func_176745_a()], endDir, axis, te)) continue;
                te.axleHandlers[endDir.func_176745_a()].propogate(masterIn, key, rotRatioIn, 0.0, handler.renderOffset);
                continue;
            }
            TileEntity endTE = te.func_145831_w().func_175625_s(te.func_174877_v().func_177972_a(endDir));
            Direction oEndDir = endDir.func_176734_d();
            if (endTE == null) continue;
            LazyOptional axisOpt = endTE.getCapability(Capabilities.AXIS_CAPABILITY, oEndDir);
            if (axisOpt.isPresent()) {
                ((IAxisHandler)axisOpt.orElseThrow(NullPointerException::new)).trigger(masterIn, key);
            }
            if (!(axleOpt = endTE.getCapability(Capabilities.AXLE_CAPABILITY, oEndDir)).isPresent()) continue;
            ((IAxleHandler)axleOpt.orElseThrow(NullPointerException::new)).propogate(masterIn, key, handler.rotRatio, 0.0, handler.renderOffset);
        }
    }

    @Override
    @Nonnull
    public ItemStack getDrop(GearFactory.GearMaterial mat) {
        return this.inverted ? CRItems.invClutch.withMaterial(mat, 1) : CRItems.clutch.withMaterial(mat, 1);
    }

    @Override
    public VoxelShape getBoundingBox(@Nullable Direction side, @Nullable Direction.Axis axis) {
        return side != null || axis == null ? VoxelShapes.func_197880_a() : SHAPES_CLUTCH[axis.ordinal()];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(MechanismTileEntity te, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, float partialTicks, GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis) {
        if (axis == null) {
            return;
        }
        MechanismTileEntity.SidedAxleHandler handler = te.axleHandlers[6];
        if (axis != Direction.Axis.Y) {
            Quaternion rotation = (axis == Direction.Axis.X ? Vector3f.field_229182_e_ : Vector3f.field_229179_b_).func_229187_a_(90.0f);
            matrix.func_227863_a_(rotation);
        }
        TextureAtlasSprite endSprite = CRRenderUtil.getTextureSprite(CRRenderTypes.AXLE_ENDS_TEXTURE);
        TextureAtlasSprite sideSprite = CRRenderUtil.getTextureSprite(this.inverted ? CRRenderTypes.CLUTCH_SIDE_INVERTED_TEXTURE : CRRenderTypes.CLUTCH_SIDE_TEXTURE);
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228639_c_());
        float size = 0.25f;
        float height = 0.5001f;
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-size), (float)0.0f, (float)(-size), (float)endSprite.func_94209_e(), (float)endSprite.func_94206_g(), (float)0.0f, (float)-1.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)size, (float)0.0f, (float)(-size), (float)endSprite.func_94212_f(), (float)endSprite.func_94206_g(), (float)0.0f, (float)-1.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)size, (float)0.0f, (float)size, (float)endSprite.func_94212_f(), (float)endSprite.func_94210_h(), (float)0.0f, (float)-1.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-size), (float)0.0f, (float)size, (float)endSprite.func_94209_e(), (float)endSprite.func_94210_h(), (float)0.0f, (float)-1.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-size), (float)height, (float)size, (float)endSprite.func_94209_e(), (float)endSprite.func_94210_h(), (float)0.0f, (float)1.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)size, (float)height, (float)size, (float)endSprite.func_94212_f(), (float)endSprite.func_94210_h(), (float)0.0f, (float)1.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)size, (float)height, (float)(-size), (float)endSprite.func_94212_f(), (float)endSprite.func_94206_g(), (float)0.0f, (float)1.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-size), (float)height, (float)(-size), (float)endSprite.func_94209_e(), (float)endSprite.func_94206_g(), (float)0.0f, (float)1.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-size), (float)height, (float)(-size), (float)sideSprite.func_94209_e(), (float)sideSprite.func_94210_h(), (float)0.0f, (float)0.0f, (float)-1.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)size, (float)height, (float)(-size), (float)sideSprite.func_94212_f(), (float)sideSprite.func_94210_h(), (float)0.0f, (float)0.0f, (float)-1.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)size, (float)0.0f, (float)(-size), (float)sideSprite.func_94212_f(), (float)sideSprite.func_94206_g(), (float)0.0f, (float)0.0f, (float)-1.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-size), (float)0.0f, (float)(-size), (float)sideSprite.func_94209_e(), (float)sideSprite.func_94206_g(), (float)0.0f, (float)0.0f, (float)-1.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-size), (float)0.0f, (float)size, (float)sideSprite.func_94212_f(), (float)sideSprite.func_94206_g(), (float)0.0f, (float)0.0f, (float)1.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)size, (float)0.0f, (float)size, (float)sideSprite.func_94209_e(), (float)sideSprite.func_94206_g(), (float)0.0f, (float)0.0f, (float)1.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)size, (float)height, (float)size, (float)sideSprite.func_94209_e(), (float)sideSprite.func_94210_h(), (float)0.0f, (float)0.0f, (float)1.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-size), (float)height, (float)size, (float)sideSprite.func_94212_f(), (float)sideSprite.func_94210_h(), (float)0.0f, (float)0.0f, (float)1.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-size), (float)0.0f, (float)size, (float)sideSprite.func_94209_e(), (float)sideSprite.func_94206_g(), (float)-1.0f, (float)0.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-size), (float)height, (float)size, (float)sideSprite.func_94209_e(), (float)sideSprite.func_94210_h(), (float)-1.0f, (float)0.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-size), (float)height, (float)(-size), (float)sideSprite.func_94212_f(), (float)sideSprite.func_94210_h(), (float)-1.0f, (float)0.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-size), (float)0.0f, (float)(-size), (float)sideSprite.func_94212_f(), (float)sideSprite.func_94206_g(), (float)-1.0f, (float)0.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)size, (float)height, (float)(-size), (float)sideSprite.func_94209_e(), (float)sideSprite.func_94210_h(), (float)1.0f, (float)0.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)size, (float)height, (float)size, (float)sideSprite.func_94212_f(), (float)sideSprite.func_94210_h(), (float)1.0f, (float)0.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)size, (float)0.0f, (float)size, (float)sideSprite.func_94212_f(), (float)sideSprite.func_94206_g(), (float)1.0f, (float)0.0f, (float)0.0f, (int)combinedLight);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)size, (float)0.0f, (float)(-size), (float)sideSprite.func_94209_e(), (float)sideSprite.func_94206_g(), (float)1.0f, (float)0.0f, (float)0.0f, (int)combinedLight);
        float angle = handler.getAngle(partialTicks);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        CRModels.drawAxle(matrix, buffer, combinedLight, mat.getColor());
    }

    static {
        MechanismClutch.SHAPES_CLUTCH[0] = VoxelShapes.func_197872_a((VoxelShape)SHAPES[0], (VoxelShape)Block.func_208617_a((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        MechanismClutch.SHAPES_CLUTCH[1] = VoxelShapes.func_197872_a((VoxelShape)SHAPES[1], (VoxelShape)Block.func_208617_a((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)4.0));
        MechanismClutch.SHAPES_CLUTCH[2] = VoxelShapes.func_197872_a((VoxelShape)SHAPES[2], (VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0));
    }
}

