/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.rotary.ICogHandler;
import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.blocks.rotary.Mechanism;
import com.Da_Technomancer.crossroads.items.itemSets.GearFactory;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.IMechanism;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.MechanismAxle;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.MechanismClutch;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.MechanismSmallGear;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.MechanismToggleGear;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.packets.ClientPacket;
import com.Da_Technomancer.essentials.packets.ILongReceiver;
import com.Da_Technomancer.essentials.packets.SendLongToClient;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

public class MechanismTileEntity
extends TileEntity
implements ITickableTileEntity,
ILongReceiver,
IInfoTE {
    @ObjectHolder(value="crossroads:mechanism")
    public static TileEntityType<MechanismTileEntity> type = null;
    public static final ArrayList<IMechanism> MECHANISMS = new ArrayList(6);
    public final IMechanism[] members = new IMechanism[7];
    public final GearFactory.GearMaterial[] mats = new GearFactory.GearMaterial[7];
    private final double[][] motionData = new double[7][4];
    private final double[] inertia = new double[7];
    public final VoxelShape[] boundingBoxes = new VoxelShape[7];
    private boolean updateMembers = false;
    private Direction.Axis axleAxis;
    public int redstoneIn = 0;
    protected final SidedAxleHandler[] axleHandlers = new SidedAxleHandler[]{new SidedAxleHandler(0), new SidedAxleHandler(1), new SidedAxleHandler(2), new SidedAxleHandler(3), new SidedAxleHandler(4), new SidedAxleHandler(5), new SidedAxleHandler(6)};
    private final LazyOptional<IAxleHandler>[] axleOpts = new LazyOptional[]{LazyOptional.of(() -> this.axleHandlers[0]), LazyOptional.of(() -> this.axleHandlers[1]), LazyOptional.of(() -> this.axleHandlers[2]), LazyOptional.of(() -> this.axleHandlers[3]), LazyOptional.of(() -> this.axleHandlers[4]), LazyOptional.of(() -> this.axleHandlers[5]), LazyOptional.of(() -> this.axleHandlers[6])};
    private final LazyOptional<ICogHandler>[] cogOpts = new LazyOptional[]{LazyOptional.of(() -> new SidedCogHandler(0)), LazyOptional.of(() -> new SidedCogHandler(1)), LazyOptional.of(() -> new SidedCogHandler(2)), LazyOptional.of(() -> new SidedCogHandler(3)), LazyOptional.of(() -> new SidedCogHandler(4)), LazyOptional.of(() -> new SidedCogHandler(5))};

    public MechanismTileEntity() {
        super(type);
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        int part = -1;
        Vec3d hitVec = hit.func_216347_e().func_178786_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        for (int i = 0; i < 7; ++i) {
            if (this.boundingBoxes[i] == null || !Mechanism.voxelContains(this.boundingBoxes[i], hitVec)) continue;
            part = i;
            break;
        }
        if (part == -1) {
            return;
        }
        RotaryUtil.addRotaryInfo(chat, this.motionData[part], this.inertia[part], this.axleHandlers[part].rotRatio, false);
    }

    public void setMechanism(int index, @Nullable IMechanism mechanism, @Nullable GearFactory.GearMaterial mat, @Nullable Direction.Axis axis, boolean newTE) {
        this.members[index] = mechanism;
        this.mats[index] = mat;
        if (index == 6 && this.getAxleAxis() != axis) {
            this.axleAxis = axis;
            if (!newTE && !this.field_145850_b.field_72995_K) {
                CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, (ClientPacket)new SendLongToClient(14, axis == null ? -1L : (long)axis.ordinal(), this.field_174879_c));
            }
        }
        if (newTE) {
            this.updateMembers = true;
        } else {
            this.axleHandlers[index].updateStates(true);
        }
        this.func_70296_d();
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        int i;
        super.func_189515_b(nbt);
        for (i = 0; i < 7; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.motionData[i][j] == 0.0) continue;
                nbt.func_74780_a("[" + i + "," + j + "]mot", this.motionData[i][j]);
            }
        }
        for (i = 0; i < 7; ++i) {
            if (this.members[i] == null || this.mats[i] == null) continue;
            nbt.func_74768_a("[" + i + "]memb", MECHANISMS.indexOf(this.members[i]));
            nbt.func_74778_a("[" + i + "]mat", this.mats[i].getId());
        }
        if (this.members[6] != null && this.mats[6] != null && this.getAxleAxis() != null) {
            nbt.func_74768_a("axis", this.getAxleAxis().ordinal());
        }
        nbt.func_74768_a("reds", this.redstoneIn);
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        for (int i = 0; i < 7; ++i) {
            if (this.members[i] == null || this.mats[i] == null) continue;
            nbt.func_74768_a("[" + i + "]memb", MECHANISMS.indexOf(this.members[i]));
            nbt.func_74778_a("[" + i + "]mat", this.mats[i].getId());
        }
        if (this.members[6] != null && this.mats[6] != null && this.getAxleAxis() != null) {
            nbt.func_74768_a("axis", this.getAxleAxis().ordinal());
        }
        nbt.func_74768_a("reds", this.redstoneIn);
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.axleAxis = nbt.func_74764_b("[6]memb") && nbt.func_74764_b("[6]mat") ? Direction.Axis.values()[nbt.func_74762_e("axis")] : null;
        for (int i = 0; i < 7; ++i) {
            if (!nbt.func_74764_b("[" + i + "]memb") || !nbt.func_74764_b("[" + i + "]mat")) continue;
            this.members[i] = MECHANISMS.get(nbt.func_74762_e("[" + i + "]memb"));
            if (this.members[i] == null) continue;
            this.mats[i] = GearFactory.findMaterial(nbt.func_74779_i("[" + i + "]mat"));
            for (int j = 0; j < 4; ++j) {
                this.motionData[i][j] = nbt.func_74769_h("[" + i + "," + j + "]mot");
            }
            this.axleHandlers[i].updateStates(false);
        }
        this.redstoneIn = nbt.func_74762_e("reds");
    }

    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity sendingPlayer) {
        if (identifier >= 7 && identifier < 14) {
            if (message == -1L) {
                this.members[identifier - 7] = null;
                this.mats[identifier - 7] = null;
            } else {
                this.members[identifier - 7] = MECHANISMS.get((int)(message & 0xFFFFFFFFL));
                this.mats[identifier - 7] = GearFactory.GearMaterial.deserialize((int)(message >>> 32));
            }
            this.axleHandlers[identifier - 7].updateStates(false);
        } else if (identifier == 14) {
            this.axleAxis = message == -1L ? null : Direction.Axis.values()[(int)message];
            this.axleHandlers[6].updateStates(false);
        } else if (identifier == 15) {
            this.redstoneIn = (int)message;
        }
    }

    public void func_73660_a() {
        if (this.updateMembers && !this.field_145850_b.field_72995_K) {
            CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, (ClientPacket)new SendLongToClient(14, this.getAxleAxis() == null ? -1L : (long)this.getAxleAxis().ordinal(), this.field_174879_c));
            for (int i = 0; i < 7; ++i) {
                this.axleHandlers[i].updateStates(true);
            }
            this.updateMembers = false;
        }
    }

    public void updateRedstone() {
        int reds = RedstoneUtil.getRedstoneAtPos((World)this.field_145850_b, (BlockPos)this.field_174879_c);
        if (reds != this.redstoneIn) {
            this.func_70296_d();
            for (int i = 0; i < 7; ++i) {
                if (this.members[i] == null) continue;
                this.members[i].onRedstoneChange(this.redstoneIn, reds, this.mats[i], i == 6 ? null : Direction.func_82600_a((int)i), this.getAxleAxis(), this.motionData[i], this);
            }
            this.redstoneIn = reds;
            CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, (ClientPacket)new SendLongToClient(15, (long)this.redstoneIn, this.field_174879_c));
        }
    }

    public float getRedstone() {
        return this.members[6] != null && this.getAxleAxis() != null ? (float)this.members[6].getCircuitSignal(this.mats[6], this.getAxleAxis(), this.motionData[6], this) : 0.0f;
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int i = 0; i < 6; ++i) {
            this.cogOpts[i].invalidate();
            this.axleOpts[i].invalidate();
        }
        this.axleOpts[6].invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == Capabilities.COG_CAPABILITY && facing != null) {
            if (this.members[facing.func_176745_a()] != null && this.members[facing.func_176745_a()].hasCap(capability, facing, this.mats[facing.func_176745_a()], facing, this.getAxleAxis(), this)) {
                return this.cogOpts[facing.func_176745_a()];
            }
            return LazyOptional.empty();
        }
        if (capability == Capabilities.AXLE_CAPABILITY && facing != null) {
            if (this.members[facing.func_176745_a()] == null && this.getAxleAxis() == facing.func_176740_k() && this.members[6] != null) {
                return this.members[6].hasCap(capability, facing, this.mats[6], null, this.getAxleAxis(), this) ? this.axleOpts[6] : LazyOptional.empty();
            }
            return this.members[facing.func_176745_a()] != null && this.members[facing.func_176745_a()].hasCap(capability, facing, this.mats[facing.func_176745_a()], facing, this.getAxleAxis(), this) ? this.axleOpts[facing.func_176745_a()] : LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    public Direction.Axis getAxleAxis() {
        return this.axleAxis;
    }

    static {
        MECHANISMS.add(new MechanismSmallGear());
        MECHANISMS.add(new MechanismAxle());
        MECHANISMS.add(new MechanismClutch(false));
        MECHANISMS.add(new MechanismClutch(true));
        MECHANISMS.add(new MechanismToggleGear(false));
        MECHANISMS.add(new MechanismToggleGear(true));
    }

    protected class SidedAxleHandler
    implements IAxleHandler {
        private final int side;
        protected byte updateKey;
        protected double rotRatio;
        protected boolean renderOffset;
        protected IAxisHandler axis;

        private SidedAxleHandler(int sideIn) {
            this.side = sideIn;
        }

        @Override
        public double[] getMotionData() {
            return MechanismTileEntity.this.motionData[this.side];
        }

        @Override
        public void propogate(IAxisHandler masterIn, byte key, double rotRatioIn, double lastRadius, boolean renderOffset) {
            if (MechanismTileEntity.this.members[this.side] != null) {
                this.renderOffset = renderOffset;
                this.axis = masterIn;
                MechanismTileEntity.this.members[this.side].propogate(MechanismTileEntity.this.mats[this.side], this.side == 6 ? null : Direction.func_82600_a((int)this.side), MechanismTileEntity.this.getAxleAxis(), MechanismTileEntity.this, this, masterIn, key, rotRatioIn, lastRadius);
            }
        }

        @Override
        public void disconnect() {
            this.axis = null;
        }

        @Override
        public double getMoInertia() {
            return MechanismTileEntity.this.inertia[this.side];
        }

        @Override
        public float getAngle(float partialTicks) {
            return this.axis == null ? 0.0f : this.axis.getAngle(this.rotRatio, partialTicks, this.renderOffset, 22.5f);
        }

        private void updateStates(boolean sendPacket) {
            if (MechanismTileEntity.this.members[this.side] == null || MechanismTileEntity.this.mats[this.side] == null) {
                ((MechanismTileEntity)MechanismTileEntity.this).inertia[this.side] = 0.0;
                ((MechanismTileEntity)MechanismTileEntity.this).motionData[this.side][0] = 0.0;
                ((MechanismTileEntity)MechanismTileEntity.this).motionData[this.side][1] = 0.0;
                ((MechanismTileEntity)MechanismTileEntity.this).motionData[this.side][2] = 0.0;
                ((MechanismTileEntity)MechanismTileEntity.this).motionData[this.side][3] = 0.0;
                MechanismTileEntity.this.boundingBoxes[this.side] = null;
            } else {
                ((MechanismTileEntity)MechanismTileEntity.this).inertia[this.side] = MechanismTileEntity.this.members[this.side].getInertia(MechanismTileEntity.this.mats[this.side], this.side == 6 ? null : Direction.func_82600_a((int)this.side), MechanismTileEntity.this.getAxleAxis());
                MechanismTileEntity.this.boundingBoxes[this.side] = MechanismTileEntity.this.members[this.side].getBoundingBox(this.side == 6 ? null : Direction.func_82600_a((int)this.side), MechanismTileEntity.this.getAxleAxis());
            }
            if (sendPacket && !((MechanismTileEntity)MechanismTileEntity.this).field_145850_b.field_72995_K) {
                CRPackets.sendPacketAround(MechanismTileEntity.this.field_145850_b, MechanismTileEntity.this.field_174879_c, (ClientPacket)new SendLongToClient(this.side + 7, MechanismTileEntity.this.members[this.side] == null ? -1L : (long)MECHANISMS.indexOf(MechanismTileEntity.this.members[this.side]) & 0xFFFFFFFFL | (long)MechanismTileEntity.this.mats[this.side].serialize() << 32, MechanismTileEntity.this.field_174879_c));
            }
        }

        @Override
        public double getRotationRatio() {
            return this.rotRatio;
        }

        @Override
        public void markChanged() {
            MechanismTileEntity.this.func_70296_d();
        }
    }

    private class SidedCogHandler
    implements ICogHandler {
        private final int side;

        private SidedCogHandler(int sideIn) {
            this.side = sideIn;
        }

        @Override
        public void connect(IAxisHandler masterIn, byte key, double rotationRatioIn, double lastRadius, Direction cogOrient, boolean renderOffset) {
            MechanismTileEntity.this.axleHandlers[this.side].propogate(masterIn, key, rotationRatioIn, lastRadius, !renderOffset);
        }

        @Override
        public IAxleHandler getAxle() {
            return MechanismTileEntity.this.axleHandlers[this.side];
        }
    }
}

