/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.technomancy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.IBeamHandler;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.technomancy.BeamCage;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class CageChargerTileEntity
extends TileEntity
implements IInfoTE {
    @ObjectHolder(value="cage_charger")
    private static TileEntityType<CageChargerTileEntity> type = null;
    private ItemStack cage = ItemStack.field_190927_a;
    private final LazyOptional<IBeamHandler> beamOpt = LazyOptional.of(() -> new BeamHandler());
    private final LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new ItemHandler());

    public CageChargerTileEntity() {
        super(type);
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        if (!this.cage.func_190926_b()) {
            BeamUnit stored = BeamCage.getStored(this.cage);
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.beam_cage.energy", new Object[]{stored.getEnergy(), 2048}));
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.beam_cage.potential", new Object[]{stored.getPotential(), 2048}));
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.beam_cage.stability", new Object[]{stored.getStability(), 2048}));
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.beam_cage.void", new Object[]{stored.getVoid(), 2048}));
        } else {
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.cage_charger.empty", new Object[0]));
        }
    }

    public void setCage(ItemStack cage) {
        this.cage = cage;
        this.func_70296_d();
    }

    public ItemStack getCage() {
        return this.cage;
    }

    public float getRedstone() {
        if (this.cage.func_190926_b()) {
            return 0.0f;
        }
        return BeamCage.getStored(this.cage).getPower();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.beamOpt.invalidate();
        this.itemOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.BEAM_CAPABILITY) {
            return this.beamOpt;
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (!this.cage.func_190926_b()) {
            nbt.func_218657_a("inv", (INBT)this.cage.func_77955_b(new CompoundNBT()));
        }
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.cage = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("inv"));
    }

    private class BeamHandler
    implements IBeamHandler {
        private BeamHandler() {
        }

        @Override
        public void setBeam(BeamUnit mag) {
            if (!mag.isEmpty() && !CageChargerTileEntity.this.cage.func_190926_b()) {
                BeamUnit cageBeam = BeamCage.getStored(CageChargerTileEntity.this.cage);
                int energy = cageBeam.getEnergy();
                int potential = cageBeam.getPotential();
                int stability = cageBeam.getStability();
                int voi = cageBeam.getVoid();
                cageBeam = new BeamUnit(energy += mag.getEnergy(), potential += mag.getPotential(), stability += mag.getStability(), voi += mag.getVoid());
                BeamCage.storeBeam(CageChargerTileEntity.this.cage, cageBeam);
                CageChargerTileEntity.this.func_70296_d();
            }
        }
    }

    private class ItemHandler
    implements IItemHandler {
        private ItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return CageChargerTileEntity.this.cage;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.isItemValid(slot, stack) && CageChargerTileEntity.this.cage.func_190926_b()) {
                if (!simulate) {
                    CageChargerTileEntity.this.cage = stack;
                    CageChargerTileEntity.this.func_70296_d();
                    CageChargerTileEntity.this.field_145850_b.func_180501_a(CageChargerTileEntity.this.field_174879_c, (BlockState)CRBlocks.cageCharger.func_176223_P().func_206870_a((IProperty)CRProperties.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                }
                return ItemStack.field_190927_a;
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 && !CageChargerTileEntity.this.cage.func_190926_b() && amount > 0) {
                if (!simulate) {
                    ItemStack out = CageChargerTileEntity.this.cage;
                    CageChargerTileEntity.this.cage = ItemStack.field_190927_a;
                    CageChargerTileEntity.this.func_70296_d();
                    CageChargerTileEntity.this.field_145850_b.func_180501_a(CageChargerTileEntity.this.field_174879_c, (BlockState)CRBlocks.cageCharger.func_176223_P().func_206870_a((IProperty)CRProperties.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
                    return out;
                }
                return CageChargerTileEntity.this.cage;
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 && stack.func_77973_b() == CRItems.beamCage;
        }
    }
}

