/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.technomancy;

import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.technomancy.FluxUtil;
import com.Da_Technomancer.crossroads.API.technomancy.IFluxLink;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.packets.ClientPacket;
import com.Da_Technomancer.essentials.packets.SendLongToClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class FluxNodeTileEntity
extends TileEntity
implements ITickableTileEntity,
IFluxLink {
    @ObjectHolder(value="flux_node")
    public static TileEntityType<FluxNodeTileEntity> type = null;
    private static final float SPIN_RATE = 3.6f;
    private HashSet<BlockPos> links = new HashSet(16);
    private int entropy;
    private int entropyClient;
    private float angle;
    private int fluxToTrans = 0;

    public FluxNodeTileEntity() {
        super(type);
    }

    private void syncFlux() {
        if (this.entropyClient == 0 ^ this.entropy == 0 || Math.abs(this.entropyClient - this.entropy) >= 4) {
            this.entropyClient = this.entropy;
            CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, (ClientPacket)new SendLongToClient(0, (long)this.entropy, this.field_174879_c));
        }
    }

    public float getRenderAngle(float partialTicks) {
        return this.angle + partialTicks * (float)this.entropy * 3.6f / 20.0f;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_186662_g((double)this.getRange());
    }

    private boolean overSafeLimit() {
        return (float)this.entropy * 1.5f >= (float)this.getMaxFlux();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.angle += (float)this.entropy * 3.6f / 20.0f;
            if (this.field_145850_b.func_82737_E() % 10L == 0L && this.overSafeLimit()) {
                CRRenderUtil.addArc(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, (float)this.field_174879_c.func_177958_n() + 1.5f, (float)this.field_174879_c.func_177956_o() + 1.5f, (float)this.field_174879_c.func_177952_p() + 1.5f, 3, 1.0f, FluxUtil.COLOR_CODES[(int)(this.field_145850_b.func_82737_E() % 3L)]);
            }
        } else if (this.field_145850_b.func_82737_E() % 4L == 0L) {
            this.syncFlux();
            this.fluxToTrans += this.entropy;
            this.entropy = 0;
            this.func_70296_d();
        } else if (this.field_145850_b.func_82737_E() % 4L == 1L) {
            this.entropy += FluxUtil.performTransfer(this, this.links, this.fluxToTrans);
            this.fluxToTrans = 0;
            FluxUtil.checkFluxOverload(this);
            this.func_70296_d();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("angle", this.angle);
        nbt.func_74768_a("entropy", this.entropy);
        nbt.func_74768_a("flux_trans", this.fluxToTrans);
        int count = 0;
        for (BlockPos relPos : this.links) {
            nbt.func_74772_a("link_" + count++, relPos.func_218275_a());
        }
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74768_a("entropy", this.entropy);
        nbt.func_74776_a("angle", this.angle);
        int count = 0;
        for (BlockPos relPos : this.links) {
            nbt.func_74772_a("link_" + count++, relPos.func_218275_a());
        }
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.angle = nbt.func_74760_g("angle");
        this.entropyClient = this.entropy = nbt.func_74762_e("entropy");
        this.fluxToTrans = nbt.func_74762_e("flux_trans");
        int count = 0;
        while (nbt.func_74764_b("link_" + count)) {
            this.links.add(BlockPos.func_218283_e((long)nbt.func_74763_f("link_" + count)));
            ++count;
        }
    }

    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity serverPlayerEntity) {
        if (identifier == 0) {
            this.entropy = (int)message;
        } else if (identifier == 8) {
            this.links.add(BlockPos.func_218283_e((long)message));
            this.func_70296_d();
        } else if (identifier == 9) {
            this.links.clear();
            this.func_70296_d();
        }
    }

    @Override
    public int getReadingFlux() {
        return FluxUtil.findReadingFlux(this, this.entropy, this.fluxToTrans);
    }

    @Override
    public int getFlux() {
        return this.entropy;
    }

    @Override
    public void addFlux(int deltaFlux) {
        this.entropy += deltaFlux;
        this.func_70296_d();
    }

    @Override
    public void setFlux(int newFlux) {
        this.entropy = newFlux;
        this.func_70296_d();
    }

    public Set<BlockPos> getLinks() {
        return this.links;
    }

    @Override
    public IFluxLink.Behaviour getBehaviour() {
        return IFluxLink.Behaviour.NODE;
    }

    @Override
    public boolean allowAccepting() {
        return RedstoneUtil.getRedstoneAtPos((World)this.field_145850_b, (BlockPos)this.field_174879_c) == 0;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        FluxUtil.addFluxInfo(chat, this, -1);
        FluxUtil.addLinkInfo(chat, this);
    }
}

