/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;

public class CircuitUtil
extends RedstoneUtil {
    public static float combineRedsSources(CircHandler handler) {
        if (!handler.builtConnections) {
            handler.buildConnections();
        }
        return CircuitUtil.sanitize((float)Math.max(handler.getCircRedstone(), (float)handler.getWorldRedstone()));
    }

    public static LazyOptional<IRedstoneHandler> makeBaseCircuitOptional(TileEntity te, CircHandler handler, float startingRedstone) {
        LazyOptional optional = LazyOptional.of(() -> handler);
        handler.setup((LazyOptional<IRedstoneHandler>)optional, te, startingRedstone);
        return optional;
    }

    public static void updateFromWorld(CircHandler handler, Block updatingBlock) {
        if (updatingBlock != Blocks.field_150488_af && !(updatingBlock instanceof RedstoneDiodeBlock)) {
            handler.buildConnections();
        }
        handler.updateWorldRedstone();
    }

    public static class CircHandler
    implements IRedstoneHandler {
        private ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>> sources = new ArrayList(1);
        private boolean builtConnections = false;
        private WeakReference<LazyOptional<IRedstoneHandler>> redsRef;
        private float circRedstone;
        private int worldRedstone;
        private TileEntity te;

        public void setup(LazyOptional<IRedstoneHandler> circuitOpt, TileEntity te, float initCircRedstone) {
            this.redsRef = new WeakReference<LazyOptional<IRedstoneHandler>>(circuitOpt);
            this.circRedstone = initCircRedstone;
            this.te = te;
        }

        public float getCircRedstone() {
            return this.circRedstone;
        }

        public int getWorldRedstone() {
            return this.worldRedstone;
        }

        public void read(BlockState state, CompoundNBT nbt) {
            this.circRedstone = nbt.func_74760_g("circ_reds");
            this.worldRedstone = nbt.func_74762_e("reds");
        }

        public void write(CompoundNBT nbt) {
            nbt.func_74776_a("circ_reds", this.circRedstone);
            nbt.func_74768_a("reds", this.worldRedstone);
        }

        public void updateWorldRedstone() {
            int prevWorldReds = this.worldRedstone;
            this.worldRedstone = 0;
            Direction[] dirsToCheck = Direction.values();
            for (Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction> src : this.sources) {
                LazyOptional srcOpt = (LazyOptional)((WeakReference)src.getLeft()).get();
                if (srcOpt == null || !srcOpt.isPresent()) continue;
                dirsToCheck[((Direction)src.getRight()).func_176745_a()] = null;
            }
            World world = this.te.func_145831_w();
            BlockPos pos = this.te.func_174877_v();
            for (Direction dir : dirsToCheck) {
                if (dir == null || world == null) continue;
                this.worldRedstone = Math.max(this.worldRedstone, CircuitUtil.getRedstoneOnSide((World)world, (BlockPos)pos, (Direction)dir));
            }
            this.worldRedstone = CircuitUtil.clampToVanilla((float)this.worldRedstone);
            if (prevWorldReds != this.worldRedstone) {
                this.te.func_70296_d();
            }
        }

        private void buildConnections() {
            World world;
            if (this.te != null && (world = this.te.func_145831_w()) != null && !world.field_72995_K) {
                BlockPos pos = this.te.func_174877_v();
                this.builtConnections = true;
                ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>> preSrc = new ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>>(this.sources.size());
                preSrc.addAll(this.sources);
                this.sources.clear();
                for (Direction checkDir : Direction.values()) {
                    IRedstoneHandler otherHandler;
                    TileEntity checkTE = world.func_175625_s(pos.func_177972_a(checkDir));
                    if (checkTE == null || (otherHandler = (IRedstoneHandler)BlockUtil.get((LazyOptional)checkTE.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, checkDir.func_176734_d()))) == null) continue;
                    otherHandler.requestSrc(this.redsRef, 0, checkDir.func_176734_d(), checkDir);
                }
                if (this.sources.size() != preSrc.size() || !this.sources.containsAll(preSrc)) {
                    world.func_205220_G_().func_205362_a(pos, (Object)ESBlocks.redstoneTransmitter, 2, TickPriority.NORMAL);
                }
            }
            this.updateWorldRedstone();
        }

        public float getOutput() {
            return CircuitUtil.combineRedsSources(this);
        }

        public void findDependents(WeakReference<LazyOptional<IRedstoneHandler>> weakReference, int i, Direction fromSide, Direction nominalSide) {
            LazyOptional srcOption = (LazyOptional)weakReference.get();
            if (srcOption != null && srcOption.isPresent()) {
                IRedstoneHandler srcHandler = (IRedstoneHandler)BlockUtil.get((LazyOptional)srcOption);
                srcHandler.addDependent(this.redsRef, nominalSide);
                Pair srcEntry = Pair.of(weakReference, (Object)fromSide);
                if (!this.sources.contains(srcEntry)) {
                    this.sources.add((Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>)srcEntry);
                }
            }
        }

        public void requestSrc(WeakReference<LazyOptional<IRedstoneHandler>> weakReference, int i, Direction direction, Direction direction1) {
        }

        public void addSrc(WeakReference<LazyOptional<IRedstoneHandler>> weakReference, Direction direction) {
            Pair srcEntry = Pair.of(weakReference, (Object)direction);
            if (!this.sources.contains(srcEntry)) {
                this.sources.add((Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>)srcEntry);
                this.notifyInputChange(weakReference);
                this.updateWorldRedstone();
            }
        }

        public void addDependent(WeakReference<LazyOptional<IRedstoneHandler>> weakReference, Direction direction) {
        }

        public void notifyInputChange(WeakReference<LazyOptional<IRedstoneHandler>> weakReference) {
            float prevCirc = this.circRedstone;
            this.circRedstone = 0.0f;
            for (int i = 0; i < this.sources.size(); ++i) {
                WeakReference src = (WeakReference)this.sources.get(i).getLeft();
                LazyOptional srcOpt = (LazyOptional)src.get();
                if (srcOpt != null && srcOpt.isPresent()) {
                    this.circRedstone = Math.max(this.circRedstone, RedstoneUtil.sanitize((float)((IRedstoneHandler)srcOpt.orElseThrow(NullPointerException::new)).getOutput()));
                    continue;
                }
                this.sources.remove(i);
                --i;
            }
            if (CircuitUtil.didChange((float)prevCirc, (float)this.circRedstone)) {
                this.te.func_70296_d();
            }
        }
    }
}

