/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.alchemy;

import com.Da_Technomancer.crossroads.API.alchemy.ElementalReagent;
import com.Da_Technomancer.crossroads.API.alchemy.EnumMatterPhase;
import com.Da_Technomancer.crossroads.API.alchemy.EnumReagents;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentStack;
import com.Da_Technomancer.crossroads.API.alchemy.StaticReagent;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.effects.alchemy.AcidAlchemyEffect;
import com.Da_Technomancer.crossroads.API.effects.alchemy.AetherEffect;
import com.Da_Technomancer.crossroads.API.effects.alchemy.AlcSaltAlchemyEffect;
import com.Da_Technomancer.crossroads.API.effects.alchemy.AquaRegiaAlchemyEffect;
import com.Da_Technomancer.crossroads.API.effects.alchemy.ChlorineAlchemyEffect;
import com.Da_Technomancer.crossroads.API.effects.alchemy.DisinfectAlchemyEffect;
import com.Da_Technomancer.crossroads.API.effects.alchemy.EldrineEffect;
import com.Da_Technomancer.crossroads.API.effects.alchemy.FusasEffect;
import com.Da_Technomancer.crossroads.API.effects.alchemy.LumenEffect;
import com.Da_Technomancer.crossroads.API.effects.alchemy.SaltAlchemyEffect;
import com.Da_Technomancer.crossroads.API.effects.alchemy.SpawnItemAlchemyEffect;
import com.Da_Technomancer.crossroads.API.effects.alchemy.StasisolEffect;
import com.Da_Technomancer.crossroads.API.effects.alchemy.VoltusEffect;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.crafting.CRItemTags;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.PredicateMap;
import com.Da_Technomancer.crossroads.items.crafting.recipes.AlchemyRec;
import com.Da_Technomancer.crossroads.items.itemSets.OreSetup;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public final class AlchemyCore {
    protected static final int REAGENT_COUNT = EnumReagents.values().length;
    private static final ArrayList<AlchemyRec> ELEM_REACTIONS = new ArrayList();
    public static final PredicateMap<Item, IReagent> ITEM_TO_REAGENT = new PredicateMap();
    public static final List<Pair<FluidStack, IReagent>> FLUID_TO_LIQREAGENT = new ArrayList<Pair<FluidStack, IReagent>>(5);
    public static final HashMap<String, IReagent> REAGENTS = new HashMap(REAGENT_COUNT);
    public static final HashMap<IReagent, Function<Integer, Integer>> FLAME_RANGES = new HashMap(2);

    public static List<AlchemyRec> getReactions(World world) {
        List rec = world.func_199532_z().func_215370_b(CRRecipes.ALCHEMY_TYPE, (IInventory)new Inventory(0), world);
        rec.addAll(ELEM_REACTIONS);
        return rec;
    }

    static {
        Color PHELOSTOGEN_COLOR = new Color(255, 100, 0, 150);
        Color CLEAR_COLOR = new Color(255, 255, 255, 100);
        Color TRANSLUCENT_BLUE_COLOR = new Color(0, 0, 255, 200);
        Color TRANSLUCENT_WHITE_COLOR = new Color(255, 255, 255, 200);
        Color TRANSLUCENT_LIME_COLOR = new Color(200, 255, 0, 100);
        Color TRANSLUCENT_YELLOW_COLOR = new Color(255, 255, 0, 200);
        Color BROWN_COLOR = new Color(130, 50, 0, 255);
        Color FAINT_BLUE_COLOR = new Color(0, 100, 255, 100);
        Color FAINT_RED_COLOR = new Color(200, 20, 0, 100);
        Color DARK_BLUE_COLOR = new Color(50, 50, 100);
        Color FAINT_GREEN_COLOR = new Color(0, 255, 0, 150);
        AcidAlchemyEffect ACID_EFFECT = new AcidAlchemyEffect();
        StaticReagent phel = new StaticReagent(EnumReagents.PHELOSTOGEN.id(), -275.0, -274.0, phase -> PHELOSTOGEN_COLOR, null, 2, null){

            @Override
            public boolean isLockedFlame() {
                return true;
            }
        };
        REAGENTS.put(EnumReagents.PHELOSTOGEN.id(), phel);
        FLAME_RANGES.put(phel, amount -> (int)Math.min(8L, Math.round((double)amount.intValue() / 2.0)));
        REAGENTS.put(EnumReagents.AETHER.id(), new StaticReagent(EnumReagents.AETHER.id(), -275.0, -274.0, phase -> FAINT_GREEN_COLOR, null, 1, new AetherEffect()));
        REAGENTS.put(EnumReagents.ADAMANT.id(), new StaticReagent(EnumReagents.ADAMANT.id(), 32766.0, 32767.0, phase -> DARK_BLUE_COLOR, CRItemTags.DUSTS_ADAMANT, 0, null));
        REAGENTS.put(EnumReagents.SULFUR.id(), new StaticReagent(EnumReagents.SULFUR.id(), 115.0, 445.0, phase -> phase == EnumMatterPhase.GAS ? TRANSLUCENT_YELLOW_COLOR : (phase == EnumMatterPhase.LIQUID ? Color.RED : Color.YELLOW), CRItemTags.SULFUR, 0, null));
        REAGENTS.put(EnumReagents.QUICKSILVER.id(), new StaticReagent(EnumReagents.QUICKSILVER.id(), -40.0, 560.0, phase -> Color.LIGHT_GRAY, CRItemTags.MERCURY, 0, null));
        REAGENTS.put(EnumReagents.ALCHEMICAL_SALT.id(), new StaticReagent(EnumReagents.ALCHEMICAL_SALT.id(), 900.0, 1400.0, phase -> TRANSLUCENT_WHITE_COLOR, CRItemTags.ALC_SALT, 0, new AlcSaltAlchemyEffect()));
        REAGENTS.put(EnumReagents.WATER.id(), new StaticReagent(EnumReagents.WATER.id(), 0.0, 100.0, phase -> phase == EnumMatterPhase.GAS ? TRANSLUCENT_WHITE_COLOR : TRANSLUCENT_BLUE_COLOR, CRItemTags.PURE_ICE, 0, null));
        REAGENTS.put(EnumReagents.SALT.id(), new StaticReagent(EnumReagents.SALT.id(), 800.0, 1400.0, phase -> phase == EnumMatterPhase.LIQUID ? Color.ORANGE : Color.WHITE, CRItemTags.SALT, 0, new SaltAlchemyEffect()));
        REAGENTS.put(EnumReagents.BEDROCK.id(), new StaticReagent(EnumReagents.BEDROCK.id(), 32766.0, 32767.0, phase -> Color.GRAY, CRItemTags.DUSTS_BEDROCK, 0, null));
        REAGENTS.put(EnumReagents.SULFUR_DIOXIDE.id(), new StaticReagent(EnumReagents.SULFUR_DIOXIDE.id(), -72.0, -10.0, phase -> TRANSLUCENT_WHITE_COLOR, CRItemTags.DUSTS_SULFUR_DIOXIDE, 0, new DisinfectAlchemyEffect()));
        REAGENTS.put(EnumReagents.SULFURIC_ACID.id(), new StaticReagent(EnumReagents.SULFURIC_ACID.id(), 10.0, 340.0, phase -> BROWN_COLOR, CRItemTags.DUSTS_SULFURIC, 0, ACID_EFFECT));
        REAGENTS.put(EnumReagents.NITRIC_ACID.id(), new StaticReagent(EnumReagents.NITRIC_ACID.id(), -40.0, 80.0, phase -> Color.YELLOW, CRItemTags.DUSTS_NITRIC, 0, ACID_EFFECT));
        REAGENTS.put(EnumReagents.HYDROCHLORIC_ACID.id(), new StaticReagent(EnumReagents.HYDROCHLORIC_ACID.id(), -110.0, 90.0, phase -> CLEAR_COLOR, CRItemTags.DUSTS_HYDROCHLORIC, 0, ACID_EFFECT));
        REAGENTS.put(EnumReagents.AQUA_REGIA.id(), new StaticReagent(EnumReagents.AQUA_REGIA.id(), -40.0, 200.0, phase -> Color.ORANGE, CRItemTags.DUSTS_REGIA, 0, new AquaRegiaAlchemyEffect()));
        REAGENTS.put(EnumReagents.VANADIUM.id(), new StaticReagent(EnumReagents.VANADIUM.id(), 690.0, 1750.0, phase -> Color.YELLOW, CRItemTags.VANADIUM, 0, null));
        REAGENTS.put(EnumReagents.REDSTONE.id(), new StaticReagent(EnumReagents.REDSTONE.id(), 580.0, 32767.0, phase -> Color.RED, (ITag<Item>)Tags.Items.DUSTS_REDSTONE, 0, null));
        REAGENTS.put(EnumReagents.SLAG.id(), new StaticReagent(EnumReagents.SLAG.id(), 2000.0, 3000.0, phase -> Color.DARK_GRAY, CRItemTags.SLAG, 0, null));
        REAGENTS.put(EnumReagents.PHILOSOPHER.id(), new StaticReagent(EnumReagents.PHILOSOPHER.id(), 32766.0, 32767.0, phase -> FAINT_BLUE_COLOR, CRItemTags.ALKAHEST, 2, new SpawnItemAlchemyEffect(CRItems.philosopherStone)));
        REAGENTS.put(EnumReagents.PRACTITIONER.id(), new StaticReagent(EnumReagents.PRACTITIONER.id(), 32766.0, 32767.0, phase -> FAINT_RED_COLOR, CRItemTags.ANTI_ALKAHEST, 2, new SpawnItemAlchemyEffect(CRItems.practitionerStone)));
        REAGENTS.put(EnumReagents.CHLORINE.id(), new StaticReagent(EnumReagents.CHLORINE.id(), -100.0, -35.0, phase -> TRANSLUCENT_LIME_COLOR, CRItemTags.DUSTS_CHLORINE, 0, new ChlorineAlchemyEffect()));
        REAGENTS.put(EnumReagents.CRYSTAL.id(), new StaticReagent(EnumReagents.CRYSTAL.id(), 32766.0, 32767.0, phase -> FAINT_BLUE_COLOR, CRItemTags.ALCH_CRYSTAL, 0, null));
        REAGENTS.put(EnumReagents.IRON.id(), new StaticReagent(EnumReagents.IRON.id(), 1500.0, 2560.0, phase -> phase == EnumMatterPhase.SOLID ? Color.GRAY : Color.RED, (ITag<Item>)Tags.Items.NUGGETS_IRON, 0, null));
        REAGENTS.put(EnumReagents.GOLD.id(), new StaticReagent(EnumReagents.GOLD.id(), 1100.0, 3000.0, phase -> Color.YELLOW, (ITag<Item>)Tags.Items.NUGGETS_GOLD, 0, null));
        REAGENTS.put(EnumReagents.COPPER.id(), new StaticReagent(EnumReagents.COPPER.id(), 1000.0, 2560.0, phase -> Color.ORANGE, CRItemTags.NUGGETS_COPPER, 0, null));
        REAGENTS.put(EnumReagents.TIN.id(), new StaticReagent(EnumReagents.TIN.id(), 230.0, 2560.0, phase -> Color.LIGHT_GRAY, CRItemTags.NUGGETS_TIN, 0, null));
        REAGENTS.put(EnumReagents.GUNPOWDER.id(), new StaticReagent(EnumReagents.GUNPOWDER.id(), 32766.0, 32767.0, phase -> Color.GRAY, (ITag<Item>)Tags.Items.GUNPOWDER, 0, null));
        REAGENTS.put(EnumReagents.RUBY.id(), new StaticReagent(EnumReagents.RUBY.id(), 2000.0, 3000.0, phase -> Color.RED, CRItemTags.GEMS_RUBY, 0, null));
        REAGENTS.put(EnumReagents.EMERALD.id(), new StaticReagent(EnumReagents.EMERALD.id(), 2000.0, 3000.0, phase -> Color.GREEN, (ITag<Item>)Tags.Items.GEMS_EMERALD, 0, null));
        REAGENTS.put(EnumReagents.DIAMOND.id(), new StaticReagent(EnumReagents.DIAMOND.id(), 2000.0, 3000.0, phase -> Color.CYAN, (ITag<Item>)Tags.Items.GEMS_DIAMOND, 0, null));
        REAGENTS.put(EnumReagents.QUARTZ.id(), new StaticReagent(EnumReagents.QUARTZ.id(), 2000.0, 3000.0, phase -> Color.WHITE, (ITag<Item>)Tags.Items.GEMS_QUARTZ, 0, null));
        REAGENTS.put(EnumReagents.DENSUS.id(), new StaticReagent(EnumReagents.DENSUS.id(), 32766.0, 32767.0, phase -> Color.BLUE, CRItemTags.DENSUS, 0, null));
        REAGENTS.put(EnumReagents.ANTI_DENSUS.id(), new StaticReagent(EnumReagents.ANTI_DENSUS.id(), 32766.0, 32767.0, phase -> Color.ORANGE, CRItemTags.ANTI_DENSUS, 0, null));
        REAGENTS.put(EnumReagents.CAVORITE.id(), new StaticReagent(EnumReagents.CAVORITE.id(), 1000.0, 1001.0, phase -> Color.YELLOW, CRItemTags.CAVORITE, 0, null));
        REAGENTS.put(EnumReagents.ELEM_LIGHT.id(), new ElementalReagent(EnumReagents.ELEM_LIGHT.id(), -275, -100, new LumenEffect(), false, EnumBeamAlignments.LIGHT, new Color(200, 255, 255), null));
        REAGENTS.put(EnumReagents.ELEM_RIFT.id(), new ElementalReagent(EnumReagents.ELEM_RIFT.id(), -100, 350, new EldrineEffect(), true, EnumBeamAlignments.RIFT, Color.MAGENTA, CRItems.solidEldrine));
        REAGENTS.put(EnumReagents.ELEM_EQUAL.id(), new ElementalReagent(EnumReagents.ELEM_EQUAL.id(), 800, 1800, new StasisolEffect(), false, EnumBeamAlignments.EQUILIBRIUM, new Color(255, 128, 255), CRItems.solidStasisol));
        REAGENTS.put(EnumReagents.ELEM_FUSION.id(), new ElementalReagent(EnumReagents.ELEM_FUSION.id(), 1000, 2500, new FusasEffect(), false, EnumBeamAlignments.FUSION, new Color(128, 255, 255), CRItems.solidFusas));
        REAGENTS.put(EnumReagents.ELEM_CHARGE.id(), new ElementalReagent(EnumReagents.ELEM_CHARGE.id(), -260, -100, new VoltusEffect(), true, EnumBeamAlignments.CHARGE, new Color(255, 255, 64, 255), CRItems.solidVoltus));
        REAGENTS.put(EnumReagents.ELEM_TIME.id(), new ElementalReagent(EnumReagents.ELEM_TIME.id(), 1500, 2500, null, false, EnumBeamAlignments.TIME, new Color(255, 130, 0, 255), OreSetup.nuggetCopshowium));
        StaticReagent hellfire = new StaticReagent(EnumReagents.HELLFIRE.id(), -275.0, -274.0, phase -> Color.RED, null, 2, null){

            @Override
            public boolean isLockedFlame() {
                return true;
            }
        };
        REAGENTS.put(EnumReagents.HELLFIRE.id(), hellfire);
        FLAME_RANGES.put(hellfire, amount -> (Boolean)CRConfig.allowHellfire.get() != false ? (int)Math.min(64.0, (double)amount.intValue() * 4.0) : (int)Math.min(8L, Math.round((double)amount.intValue() / 2.0)));
        FLUID_TO_LIQREAGENT.add((Pair<FluidStack, IReagent>)Pair.of((Object)new FluidStack((Fluid)CRFluids.distilledWater.still, 100), (Object)REAGENTS.get(EnumReagents.WATER.id())));
        FLUID_TO_LIQREAGENT.add((Pair<FluidStack, IReagent>)Pair.of((Object)new FluidStack((Fluid)CRFluids.moltenIron.still, 16), (Object)REAGENTS.get(EnumReagents.IRON.id())));
        FLUID_TO_LIQREAGENT.add((Pair<FluidStack, IReagent>)Pair.of((Object)new FluidStack((Fluid)CRFluids.moltenGold.still, 16), (Object)REAGENTS.get(EnumReagents.GOLD.id())));
        FLUID_TO_LIQREAGENT.add((Pair<FluidStack, IReagent>)Pair.of((Object)new FluidStack((Fluid)CRFluids.moltenCopper.still, 16), (Object)REAGENTS.get(EnumReagents.COPPER.id())));
        FLUID_TO_LIQREAGENT.add((Pair<FluidStack, IReagent>)Pair.of((Object)new FluidStack((Fluid)CRFluids.moltenTin.still, 16), (Object)REAGENTS.get(EnumReagents.TIN.id())));
        ReagentStack[] mixElem = new ReagentStack[]{new ReagentStack(REAGENTS.get(EnumReagents.PHELOSTOGEN.id()), 1), new ReagentStack(REAGENTS.get(EnumReagents.AETHER.id()), 1), new ReagentStack(REAGENTS.get(EnumReagents.ADAMANT.id()), 1)};
        ELEM_REACTIONS.add(new AlchemyRec(new ResourceLocation("crossroads:lumen"), "", AlchemyRec.Type.ELEMENTAL, mixElem, new ReagentStack[]{new ReagentStack(REAGENTS.get(EnumReagents.ELEM_LIGHT.id()), 1)}, REAGENTS.get(EnumReagents.PRACTITIONER.id()), -300.0, 32767.0, 0.0, true, 0.0f, true));
        ELEM_REACTIONS.add(new AlchemyRec(new ResourceLocation("crossroads:eldrine"), "", AlchemyRec.Type.ELEMENTAL, mixElem, new ReagentStack[]{new ReagentStack(REAGENTS.get(EnumReagents.ELEM_RIFT.id()), 1)}, REAGENTS.get(EnumReagents.PRACTITIONER.id()), -300.0, 32767.0, 0.0, true, 0.0f, true));
        ELEM_REACTIONS.add(new AlchemyRec(new ResourceLocation("crossroads:stasisol"), "", AlchemyRec.Type.ELEMENTAL, mixElem, new ReagentStack[]{new ReagentStack(REAGENTS.get(EnumReagents.ELEM_EQUAL.id()), 1)}, REAGENTS.get(EnumReagents.PRACTITIONER.id()), -300.0, 32767.0, 0.0, true, 0.0f, true));
        ELEM_REACTIONS.add(new AlchemyRec(new ResourceLocation("crossroads:fusas"), "", AlchemyRec.Type.ELEMENTAL, mixElem, new ReagentStack[]{new ReagentStack(REAGENTS.get(EnumReagents.ELEM_FUSION.id()), 1)}, REAGENTS.get(EnumReagents.PRACTITIONER.id()), -300.0, 32767.0, 0.0, true, 0.0f, true));
        ELEM_REACTIONS.add(new AlchemyRec(new ResourceLocation("crossroads:voltus"), "", AlchemyRec.Type.ELEMENTAL, mixElem, new ReagentStack[]{new ReagentStack(REAGENTS.get(EnumReagents.ELEM_CHARGE.id()), 1)}, REAGENTS.get(EnumReagents.PRACTITIONER.id()), -300.0, 32767.0, 0.0, true, 0.0f, true));
    }
}

