/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.alchemy;

import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCore;
import com.Da_Technomancer.crossroads.API.alchemy.EnumMatterPhase;
import com.Da_Technomancer.crossroads.API.alchemy.IElementReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentStack;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.effects.alchemy.IAlchEffect;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class ElementalReagent
implements IElementReagent {
    private final boolean destroyContainer;
    private final String name;
    private final EnumBeamAlignments element;
    private final Color color;
    private final IAlchEffect effect;
    private final int melt;
    private final int boil;
    private final Item solidForm;

    public ElementalReagent(String name, int melt, int boil, IAlchEffect effect, boolean destroyContainer, EnumBeamAlignments element, Color color, @Nullable Item solidForm) {
        this.name = name;
        this.destroyContainer = destroyContainer;
        this.element = element;
        this.effect = effect;
        this.boil = boil;
        this.melt = melt;
        this.solidForm = solidForm;
        this.color = color;
        if (solidForm != null) {
            AlchemyCore.ITEM_TO_REAGENT.put(stack -> stack.getItem() == solidForm, this);
        }
    }

    @Override
    public double getMeltingPoint() {
        return this.melt;
    }

    @Override
    public double getBoilingPoint() {
        return this.boil;
    }

    @Override
    public Color getColor(EnumMatterPhase phase) {
        return this.color;
    }

    @Override
    public boolean requiresCrystal() {
        return true;
    }

    @Override
    public boolean destroysBadContainer() {
        return this.destroyContainer;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    @Nullable
    public IAlchEffect getEffect() {
        return this.effect;
    }

    @Override
    public ItemStack getStackFromReagent(ReagentStack reag) {
        return !reag.isEmpty() && reag.getType() == this ? new ItemStack((IItemProvider)this.solidForm, reag.getAmount()) : ItemStack.field_190927_a;
    }

    @Override
    public List<ItemStack> getJEISolids() {
        return this.solidForm == null ? ImmutableList.of() : ImmutableList.of((Object)new ItemStack((IItemProvider)this.solidForm));
    }

    @Override
    public EnumBeamAlignments getAlignment() {
        return this.element;
    }
}

