/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.alchemy;

import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCore;
import com.Da_Technomancer.crossroads.API.alchemy.EnumMatterPhase;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentStack;
import com.Da_Technomancer.crossroads.API.effects.alchemy.IAlchEffect;
import com.Da_Technomancer.crossroads.Crossroads;
import com.Da_Technomancer.crossroads.items.crafting.CRItemTags;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;

public class StaticReagent
implements IReagent {
    private final double melting;
    private final double boiling;
    private final int containType;
    private final IAlchEffect effect;
    private final String name;
    private final Function<EnumMatterPhase, Color> color;
    private final ITag<Item> itemTag;

    public StaticReagent(String name, double meltingPoint, double boilingPoint, Function<EnumMatterPhase, Color> color, @Nullable ITag<Item> tag, int containType, @Nullable IAlchEffect effect) {
        this.name = name;
        if (boilingPoint <= meltingPoint) {
            throw (IllegalArgumentException)Crossroads.logger.throwing((Throwable)new IllegalArgumentException("Boiling point must be greater than melting point. Material Type: " + name));
        }
        this.melting = meltingPoint;
        this.boiling = boilingPoint;
        if (tag != null) {
            AlchemyCore.ITEM_TO_REAGENT.put(arg_0 -> tag.func_230235_a_(arg_0), this);
        }
        this.containType = containType;
        this.effect = effect;
        this.color = color;
        this.itemTag = tag;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public double getMeltingPoint() {
        return this.melting;
    }

    @Override
    public double getBoilingPoint() {
        return this.boiling;
    }

    @Override
    public ItemStack getStackFromReagent(ReagentStack reag) {
        if (this.itemTag == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack out = !reag.isEmpty() && reag.getType() == this ? new ItemStack((IItemProvider)CRItemTags.getTagEntry(this.itemTag), 1) : ItemStack.field_190927_a;
        out.func_190920_e(reag.getAmount());
        return out;
    }

    @Override
    public List<ItemStack> getJEISolids() {
        if (this.itemTag != null) {
            return ((Stream)this.itemTag.func_230236_b_().parallelStream().unordered()).map(ItemStack::new).distinct().collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    @Override
    public boolean requiresCrystal() {
        return (this.containType & 3) != 0;
    }

    @Override
    public boolean destroysBadContainer() {
        return this.containType == 2;
    }

    @Override
    @Nullable
    public IAlchEffect getEffect() {
        return this.effect;
    }

    @Override
    public Color getColor(EnumMatterPhase phase) {
        return this.color.apply(phase);
    }
}

