/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.beams;

import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;

public class BeamUnitStorage {
    private int[] stored = new int[4];

    public void addBeam(@Nonnull BeamUnit mag) {
        this.stored[0] = this.stored[0] + mag.getEnergy();
        this.stored[1] = this.stored[1] + mag.getPotential();
        this.stored[2] = this.stored[2] + mag.getStability();
        this.stored[3] = this.stored[3] + mag.getVoid();
    }

    public void addBeam(BeamUnitStorage otherStorage) {
        for (int i = 0; i < 4; ++i) {
            int n = i;
            this.stored[n] = this.stored[n] + otherStorage.stored[i];
        }
    }

    public void subtractBeam(@Nonnull BeamUnit mag) {
        this.stored[0] = this.stored[0] - mag.getEnergy();
        this.stored[1] = this.stored[1] - mag.getPotential();
        this.stored[2] = this.stored[2] - mag.getStability();
        this.stored[3] = this.stored[3] - mag.getVoid();
        if (this.stored[0] < 0) {
            this.stored[0] = 0;
        }
        if (this.stored[1] < 0) {
            this.stored[1] = 0;
        }
        if (this.stored[2] < 0) {
            this.stored[2] = 0;
        }
        if (this.stored[3] < 0) {
            this.stored[3] = 0;
        }
    }

    public boolean isEmpty() {
        return this.getPower() == 0;
    }

    public int getPower() {
        return this.stored[0] + this.stored[1] + this.stored[2] + this.stored[3];
    }

    public void clear() {
        this.stored[0] = 0;
        this.stored[1] = 0;
        this.stored[2] = 0;
        this.stored[3] = 0;
    }

    @Nonnull
    public BeamUnit getOutput() {
        return this.isEmpty() ? BeamUnit.EMPTY : new BeamUnit(this.stored[0], this.stored[1], this.stored[2], this.stored[3]);
    }

    public void writeToNBT(@Nonnull String key, CompoundNBT nbt) {
        if (!this.isEmpty()) {
            nbt.func_74783_a(key, this.stored);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeamUnitStorage that = (BeamUnitStorage)o;
        return Arrays.equals(this.stored, that.stored);
    }

    public int hashCode() {
        return Arrays.hashCode(this.stored);
    }

    public static BeamUnitStorage readFromNBT(@Nonnull String key, CompoundNBT nbt) {
        BeamUnitStorage out = new BeamUnitStorage();
        if (nbt.func_74764_b(key)) {
            out.stored = nbt.func_74759_k(key);
        }
        return out;
    }
}

