/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.effects;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.effects.BeamEffect;
import com.Da_Technomancer.crossroads.API.heat.IHeatHandler;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class EnergizeEffect
extends BeamEffect {
    private static final double MULT = 100.0;

    @Override
    public void doBeamEffect(EnumBeamAlignments align, boolean voi, int power, World worldIn, BlockPos pos, @Nullable Direction dir) {
        if (!this.performTransmute(align, voi, power, worldIn, pos)) {
            IHeatHandler hitHandler = EnergizeEffect.getHitHandler(worldIn, pos, dir);
            if (voi) {
                if (hitHandler != null) {
                    hitHandler.addHeat(-Math.min(100.0 * (double)power, hitHandler.getTemp() - -273.0));
                }
            } else if (hitHandler != null) {
                hitHandler.addHeat(Math.min(100.0 * (double)power, 50000.0 - hitHandler.getTemp()));
            } else {
                BlockPos offsetPos;
                BlockState state = worldIn.func_180495_p(pos);
                if (state.func_177230_c().isAir(state, (IBlockReader)worldIn, pos)) {
                    worldIn.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                } else if (dir != null && (state = worldIn.func_180495_p(offsetPos = pos.func_177972_a(dir))).func_177230_c().isAir(state, (IBlockReader)worldIn, offsetPos)) {
                    worldIn.func_175656_a(offsetPos, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    @Nullable
    private static IHeatHandler getHitHandler(World w, BlockPos pos, Direction side) {
        TileEntity te = w.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        LazyOptional opt = te.getCapability(Capabilities.HEAT_CAPABILITY, side);
        if (opt.isPresent()) {
            return (IHeatHandler)opt.orElseThrow(NullPointerException::new);
        }
        if (side != null) {
            opt = te.getCapability(Capabilities.HEAT_CAPABILITY, null);
        }
        if (opt.isPresent()) {
            return (IHeatHandler)opt.orElseThrow(NullPointerException::new);
        }
        return null;
    }
}

