/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.effects.alchemy;

import com.Da_Technomancer.crossroads.API.CRReflection;
import com.Da_Technomancer.crossroads.API.alchemy.EnumMatterPhase;
import com.Da_Technomancer.crossroads.API.alchemy.EnumReagents;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.effects.alchemy.IAlchEffect;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.SendBiomeUpdateToClient;
import com.Da_Technomancer.crossroads.Crossroads;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.alchemy.ReactiveSpotTileEntity;
import com.Da_Technomancer.essentials.ReflectionUtil;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.IChunk;

public class AetherEffect
implements IAlchEffect {
    private static final ITag<Block> SOIL_GROUP = BlockTags.func_199894_a((String)"crossroads:alchemy_soil");
    private static final ITag<Block> ROCK_GROUP = BlockTags.func_199894_a((String)"crossroads:alchemy_rock");
    private static final ITag<Block> FLUD_GROUP = BlockTags.func_199894_a((String)"crossroads:alchemy_fluid");
    private static final ITag<Block> CRYS_GROUP = BlockTags.func_199894_a((String)"crossroads:alchemy_crystal");
    private static final Field biomeField = ReflectionUtil.reflectField((ReflectionUtil.IReflectionKey)CRReflection.BIOME_ARRAY);

    protected Block soilBlock() {
        return Blocks.field_196658_i;
    }

    protected Block rockBlock() {
        return Blocks.field_150348_b;
    }

    protected Block fluidBlock() {
        return Blocks.field_150355_j;
    }

    protected Block crystalBlock() {
        return Blocks.field_150359_w;
    }

    protected Biome biome() {
        return Biomes.field_76772_c;
    }

    @Override
    public void doEffect(World world, BlockPos pos, int amount, EnumMatterPhase phase, ReagentMap contents) {
        BlockState oldState = world.func_180495_p(pos);
        if (contents.getQty(EnumReagents.QUICKSILVER.id()) != 0 && oldState.func_177230_c().isAir(oldState, (IBlockReader)world, pos)) {
            world.func_175656_a(pos, this.soilBlock().func_176223_P());
            return;
        }
        IChunk c = world.func_217349_x(pos);
        Biome biome = this.biome();
        if (world.func_226691_t_(pos) != biome) {
            AetherEffect.setBiomeAtPos(world, pos, biome);
            CRPackets.sendPacketToDimension(world, new SendBiomeUpdateToClient(pos, biome.getRegistryName()));
        }
        if (oldState.func_177230_c().isAir(oldState, (IBlockReader)world, pos) || oldState.func_185887_b((IBlockReader)world, pos) < 0.0f) {
            return;
        }
        if (CRYS_GROUP.func_230235_a_((Object)oldState.func_177230_c())) {
            if (oldState != this.crystalBlock().func_176223_P()) {
                world.func_175656_a(pos, this.crystalBlock().func_176223_P());
            }
        } else if (FLUD_GROUP.func_230235_a_((Object)oldState.func_177230_c())) {
            if (oldState != this.fluidBlock().func_176223_P() && oldState.func_177230_c() != CRBlocks.reactiveSpot) {
                world.func_175656_a(pos, CRBlocks.reactiveSpot.func_176223_P());
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof ReactiveSpotTileEntity) {
                    ((ReactiveSpotTileEntity)te).setTarget(this.fluidBlock().func_176223_P());
                }
            }
        } else if (ROCK_GROUP.func_230235_a_((Object)oldState.func_177230_c())) {
            if (oldState != this.rockBlock().func_176223_P()) {
                world.func_175656_a(pos, this.rockBlock().func_176223_P());
            }
        } else if (SOIL_GROUP.func_230235_a_((Object)oldState.func_177230_c())) {
            BlockPos upPos = pos.func_177984_a();
            if (this.soilBlock() == Blocks.field_196658_i && !world.func_180495_p(upPos).isAir((IBlockReader)world, upPos)) {
                if (oldState != Blocks.field_150346_d.func_176223_P()) {
                    world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
                }
            } else if (oldState != this.soilBlock().func_176223_P()) {
                world.func_175656_a(pos, this.soilBlock().func_176223_P());
            }
        }
    }

    public static void setBiomeAtPos(World world, BlockPos pos, Biome biome) {
        BiomeContainer bc = world.func_217349_x(pos).func_225549_i_();
        int arrayIndex = (pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF;
        if (biomeField != null) {
            try {
                Object o = biomeField.get(bc);
                Biome[] biomeArray = (Biome[])o;
                biomeArray[arrayIndex] = biome;
            }
            catch (IllegalAccessException | IndexOutOfBoundsException | NullPointerException e) {
                e.printStackTrace();
                Crossroads.logger.error(String.format("Failed to set biome at pos: %s; to biome: %s", pos, biome), (Throwable)e);
            }
        }
    }
}

