/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.technomancy;

import com.Da_Technomancer.crossroads.API.effects.goggles.DiamondGoggleEffect;
import com.Da_Technomancer.crossroads.API.effects.goggles.EmeraldGoggleEffect;
import com.Da_Technomancer.crossroads.API.effects.goggles.IGoggleEffect;
import com.Da_Technomancer.crossroads.API.effects.goggles.QuartzGoggleEffect;
import com.Da_Technomancer.crossroads.API.effects.goggles.RubyGoggleEffect;
import com.Da_Technomancer.crossroads.API.effects.goggles.VoidGoggleEffect;
import com.Da_Technomancer.crossroads.Keys;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.crafting.CRItemTags;
import com.Da_Technomancer.crossroads.items.itemSets.OreSetup;
import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public enum EnumGoggleLenses {
    RUBY((Predicate<ItemStack>)Ingredient.func_199805_a(CRItemTags.GEMS_RUBY), "_ruby", new RubyGoggleEffect(), Keys.controlEnergy, true),
    EMERALD((Predicate<ItemStack>)Ingredient.func_199805_a((ITag)Tags.Items.GEMS_EMERALD), "_emerald", new EmeraldGoggleEffect(), Keys.controlPotential, true),
    DIAMOND((Predicate<ItemStack>)Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND), "_diamond", new DiamondGoggleEffect(), Keys.controlStability, false),
    QUARTZ((Predicate<ItemStack>)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CRItems.pureQuartz}), "_quartz", new QuartzGoggleEffect(), null, false),
    VOID((Predicate<ItemStack>)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{OreSetup.voidCrystal}), "", new VoidGoggleEffect(), Keys.controlVoid, true);

    private final Predicate<ItemStack> item;
    private final String texturePath;
    private final IGoggleEffect effect;
    private final KeyBinding key;
    private final boolean requireEnable;

    private EnumGoggleLenses(Predicate<ItemStack> item, @Nullable String texturePath, IGoggleEffect effect, KeyBinding toggleKey, boolean requireEnable) {
        this.item = item;
        this.texturePath = texturePath;
        this.effect = effect;
        this.key = toggleKey;
        this.requireEnable = requireEnable;
    }

    public boolean matchesRecipe(ItemStack stack) {
        return this.item.test(stack);
    }

    public String getTexturePath() {
        return this.texturePath;
    }

    @Nullable
    public KeyBinding getKey() {
        return this.key;
    }

    public boolean useKey() {
        return this.requireEnable;
    }

    public void doEffect(World world, PlayerEntity player, ArrayList<ITextComponent> chat, BlockRayTraceResult ray) {
        this.effect.armorTick(world, player, chat, ray);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.US);
    }
}

