/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.technomancy;

import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.technomancy.GatewayAddress;
import com.Da_Technomancer.crossroads.Crossroads;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class GatewaySavedData
extends WorldSavedData {
    public static final String ID = "crossroads_gateways";
    private final Map<GatewayAddress, GatewayAddress.Location> addressBook = new HashMap<GatewayAddress, GatewayAddress.Location>();

    public static GatewayAddress getReservedAddress(@Nonnull ServerWorld w) {
        EnumBeamAlignments[] address = new EnumBeamAlignments[4];
        address[0] = EnumBeamAlignments.RIFT;
        long seed = w.func_72905_C();
        Random rand = new Random(seed);
        for (int i = 1; i < address.length; ++i) {
            address[i] = GatewayAddress.getLegalEntry(rand.nextInt(Integer.MAX_VALUE));
        }
        return new GatewayAddress(address);
    }

    @Nullable
    public static GatewayAddress requestAddress(@Nonnull ServerWorld w, @Nonnull BlockPos pos) {
        GatewayAddress gateAdd;
        GatewaySavedData data = GatewaySavedData.get(w);
        if (data.addressBook.size() >= (int)Math.pow(GatewayAddress.LEGAL_VALS.length, 4.0)) {
            Crossroads.logger.warn("Ran out of Technomancy Gateway Addresses! No new gateways can be built");
            Crossroads.logger.warn("Let the mod author know that someone managed to hit the limit :)");
            return null;
        }
        EnumBeamAlignments[] address = new EnumBeamAlignments[4];
        GatewayAddress reserved = GatewaySavedData.getReservedAddress(w);
        do {
            for (int i = 0; i < 4; ++i) {
                address[i] = GatewayAddress.getLegalEntry(w.field_73012_v.nextInt(GatewayAddress.LEGAL_VALS.length));
            }
        } while (data.addressBook.containsKey(gateAdd = new GatewayAddress(address)) || gateAdd.equals(reserved));
        data.addressBook.put(gateAdd, new GatewayAddress.Location(pos, (World)w));
        data.func_76185_a();
        return gateAdd;
    }

    public static void releaseAddress(@Nonnull ServerWorld w, @Nullable GatewayAddress address) {
        if (address != null) {
            GatewaySavedData data = GatewaySavedData.get(w);
            data.addressBook.remove(address);
            data.func_76185_a();
        }
    }

    @Nullable
    public static GatewayAddress.Location lookupAddress(@Nonnull ServerWorld w, @Nullable GatewayAddress address) {
        GatewaySavedData data = GatewaySavedData.get(w);
        return address == null ? null : data.addressBook.get(address);
    }

    private static GatewaySavedData get(ServerWorld world) {
        GatewaySavedData data;
        DimensionSavedDataManager storage = world.func_234922_V_().func_240901_a_().equals((Object)DimensionType.field_235999_c_.func_240901_a_()) ? world.func_217481_x() : world.func_73046_m().func_241755_D_().func_217481_x();
        try {
            data = (GatewaySavedData)storage.func_215752_a(GatewaySavedData::new, ID);
        }
        catch (NullPointerException e) {
            Crossroads.logger.error("Failed GatewaySavedData get due to null DimensionSavedDataManager", (Throwable)e);
            return new GatewaySavedData();
        }
        return data;
    }

    private GatewaySavedData() {
        super(ID);
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.addressBook.clear();
        int i = 0;
        while (nbt.func_74764_b("key_" + i)) {
            this.addressBook.put(GatewayAddress.deserialize(nbt.func_74762_e("key_" + i)), new GatewayAddress.Location(nbt.func_74763_f("pos_" + i), nbt.func_74779_i("dim_" + i)));
            ++i;
        }
        nbt.func_74762_e("atmos_charge");
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        int i = 0;
        for (Map.Entry<GatewayAddress, GatewayAddress.Location> entry : this.addressBook.entrySet()) {
            nbt.func_74768_a("key_" + i, entry.getKey().serialize());
            nbt.func_74772_a("pos_" + i, entry.getValue().pos.func_218275_a());
            nbt.func_74778_a("dim_" + i, entry.getValue().dim.toString());
            ++i;
        }
        return nbt;
    }
}

