/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.templates;

import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.gui.container.FluidSlotManager;
import com.Da_Technomancer.essentials.gui.container.IFluidSlotTE;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class InventoryTE
extends ModuleTE
implements ISidedInventory,
INamedContainerProvider,
IFluidSlotTE {
    protected final ItemStack[] inventory;
    public final FluidSlotManager[] fluidManagers = new FluidSlotManager[this.fluidTanks()];

    public InventoryTE(TileEntityType<? extends InventoryTE> type, int invSize) {
        super(type);
        this.inventory = new ItemStack[invSize];
        for (int i = 0; i < invSize; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
    }

    protected void initFluidManagers() {
        for (int i = 0; i < this.fluids.length; ++i) {
            this.fluidManagers[i] = new FluidSlotManager(this.fluids[i], this.fluidProps[i].capacity);
        }
    }

    public int getUISpeed() {
        return (int)Math.round(this.motData[0] * 100.0);
    }

    public int getUITemp() {
        return (int)this.temp;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i].func_190926_b()) continue;
            CompoundNBT stackTag = new CompoundNBT();
            this.inventory[i].func_77955_b(stackTag);
            nbt.func_218657_a("inv_" + i, (INBT)stackTag);
        }
        nbt.func_74757_a("server", true);
        return nbt;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            for (int i = 0; i < this.fluidManagers.length; ++i) {
                this.fluidManagers[i].updateState(this.fluids[i]);
            }
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        int i;
        super.func_230337_a_(state, nbt);
        for (i = 0; i < this.inventory.length; ++i) {
            if (!nbt.func_74764_b("inv_" + i)) continue;
            this.inventory[i] = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("inv_" + i));
        }
        if (nbt.func_74767_n("server")) {
            for (i = 0; i < this.fluidManagers.length; ++i) {
                this.fluidManagers[i].updateState(this.fluids[i]);
            }
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return index >= this.inventory.length ? ItemStack.field_190927_a : this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index >= this.inventory.length || this.inventory[index].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.func_70296_d();
        return this.inventory[index].func_77979_a(count);
    }

    public ItemStack func_70304_b(int index) {
        if (index >= this.inventory.length || this.inventory[index].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.func_70296_d();
        ItemStack removed = this.inventory[index];
        this.inventory[index] = ItemStack.field_190927_a;
        return removed;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= this.inventory.length) {
            return;
        }
        this.inventory[index] = stack;
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return this.inventory.length == 0 ? 0 : 64;
    }

    public void func_174888_l() {
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        if (this.inventory.length != 0) {
            this.func_70296_d();
        }
    }

    public boolean func_180462_a(int index, ItemStack stack, Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public int[] func_180463_a(Direction side) {
        int[] out = new int[this.inventory.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = i;
        }
        return out;
    }

    public IFluidHandler getFluidHandler() {
        return this.globalFluidHandler;
    }

    protected PacketBuffer createContainerBuf() {
        return new PacketBuffer(Unpooled.buffer()).func_179255_a(this.field_174879_c);
    }

    protected class ItemHandler
    implements IItemHandlerModifiable {
        private final Direction dir;

        public ItemHandler() {
            this(null);
        }

        public ItemHandler(Direction dir) {
            this.dir = dir;
        }

        public int getSlots() {
            return InventoryTE.this.inventory.length;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot >= InventoryTE.this.inventory.length ? ItemStack.field_190927_a : InventoryTE.this.inventory[slot];
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (InventoryTE.this.func_94041_b(slot, stack) && (InventoryTE.this.inventory[slot].func_190926_b() || BlockUtil.sameItem((ItemStack)stack, (ItemStack)InventoryTE.this.inventory[slot]))) {
                int oldCount = InventoryTE.this.inventory[slot].func_190916_E();
                int moved = Math.min(stack.func_190916_E(), stack.func_77976_d() - oldCount);
                ItemStack out = stack.func_77946_l();
                out.func_190920_e(stack.func_190916_E() - moved);
                if (!simulate) {
                    InventoryTE.this.func_70296_d();
                    InventoryTE.this.inventory[slot] = stack.func_77946_l();
                    InventoryTE.this.inventory[slot].func_190920_e(moved + oldCount);
                }
                return out;
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= InventoryTE.this.inventory.length || !InventoryTE.this.func_180461_b(slot, InventoryTE.this.inventory[slot], this.dir)) {
                return ItemStack.field_190927_a;
            }
            int moved = Math.min(amount, InventoryTE.this.inventory[slot].func_190916_E());
            if (simulate) {
                ItemStack simOut = InventoryTE.this.inventory[slot].func_77946_l();
                simOut.func_190920_e(moved);
                return simOut;
            }
            InventoryTE.this.func_70296_d();
            return InventoryTE.this.inventory[slot].func_77979_a(moved);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return InventoryTE.this.func_94041_b(slot, stack);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            if (slot < InventoryTE.this.inventory.length) {
                InventoryTE.this.inventory[slot] = stack;
                InventoryTE.this.func_70296_d();
            }
        }
    }
}

