/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.templates;

import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.TileEntityContainer;
import com.Da_Technomancer.essentials.gui.container.FluidSlotManager;
import com.Da_Technomancer.essentials.gui.container.IntDeferredRef;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IntReferenceHolder;

public abstract class MachineContainer<U extends InventoryTE>
extends TileEntityContainer<U> {
    public final IntDeferredRef heatRef;
    public final IntDeferredRef rotRef;
    public final IntDeferredRef[][] fluidManagerRefs;

    public MachineContainer(ContainerType<? extends MachineContainer> type, int windowId, PlayerInventory playerInv, PacketBuffer data) {
        super(type, windowId, playerInv, data);
        boolean remote = ((InventoryTE)this.te).func_145831_w().field_72995_K;
        if (((InventoryTE)this.te).useRotary()) {
            this.rotRef = new IntDeferredRef(((InventoryTE)this.te)::getUISpeed, remote);
            this.func_216958_a((IntReferenceHolder)this.rotRef);
        } else {
            this.rotRef = null;
        }
        if (((InventoryTE)this.te).useHeat()) {
            this.heatRef = new IntDeferredRef(((InventoryTE)this.te)::getUITemp, remote);
            this.func_216958_a((IntReferenceHolder)this.heatRef);
        } else {
            this.heatRef = null;
        }
        this.fluidManagerRefs = new IntDeferredRef[((InventoryTE)this.te).fluidManagers.length][2];
        for (int i = 0; i < ((InventoryTE)this.te).fluidManagers.length; ++i) {
            FluidSlotManager manager = ((InventoryTE)this.te).fluidManagers[i];
            this.fluidManagerRefs[i][0] = new IntDeferredRef(() -> ((FluidSlotManager)manager).getFluidId(), remote);
            this.fluidManagerRefs[i][1] = new IntDeferredRef(() -> ((FluidSlotManager)manager).getFluidQty(), remote);
            this.func_216958_a((IntReferenceHolder)this.fluidManagerRefs[i][0]);
            this.func_216958_a((IntReferenceHolder)this.fluidManagerRefs[i][1]);
        }
        this.addSlots();
        int[] invStart = this.getInvStart();
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInv, x, invStart[0] + x * 18, invStart[1] + 58));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, invStart[0] + x * 18, invStart[1] + y * 18));
            }
        }
    }

    @Override
    protected int slotCount() {
        return ((InventoryTE)this.te).inventory.length;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        block4: {
            super.func_75134_a(playerIn);
            if (((InventoryTE)this.te).func_145831_w().field_72995_K) break block4;
            if (!(!playerIn.func_70089_S() || playerIn instanceof ServerPlayerEntity && ((ServerPlayerEntity)playerIn).func_193105_t())) {
                for (Slot s : this.field_75151_b) {
                    if (!(s.field_75224_c instanceof FluidSlotManager.FakeInventory)) continue;
                    playerIn.field_71071_by.func_191975_a(((InventoryTE)this.te).func_145831_w(), s.func_75211_c());
                }
            } else {
                for (Slot s : this.field_75151_b) {
                    if (!(s.field_75224_c instanceof FluidSlotManager.FakeInventory)) continue;
                    playerIn.func_71019_a(s.func_75211_c(), false);
                }
            }
        }
    }
}

