/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.templates;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.heat.IHeatHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.essentials.packets.ILongReceiver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class ModuleTE
extends TileEntity
implements ITickableTileEntity,
IInfoTE,
ILongReceiver {
    protected final double[] motData = new double[4];
    protected float[] angleW = null;
    protected boolean initHeat = false;
    protected double temp;
    protected final FluidStack[] fluids = new FluidStack[this.fluidTanks()];
    protected final TankProperty[] fluidProps = new TankProperty[this.fluidTanks()];
    protected HeatHandler heatHandler;
    protected LazyOptional<IHeatHandler> heatOpt;
    protected AxleHandler axleHandler;
    protected LazyOptional<IAxleHandler> axleOpt;
    protected IFluidHandler globalFluidHandler;
    protected LazyOptional<IFluidHandler> globalFluidOpt;

    protected boolean useHeat() {
        return false;
    }

    protected boolean useRotary() {
        return false;
    }

    protected int fluidTanks() {
        return 0;
    }

    protected AxleHandler createAxleHandler() {
        return new AxleHandler();
    }

    protected HeatHandler createHeatHandler() {
        return new HeatHandler();
    }

    protected IFluidHandler createGlobalFluidHandler() {
        return new FluidHandler(-1);
    }

    public ModuleTE(TileEntityType<? extends ModuleTE> type) {
        super(type);
        if (this.useHeat()) {
            this.heatHandler = this.createHeatHandler();
            this.heatOpt = LazyOptional.of(() -> this.heatHandler);
        } else {
            this.heatHandler = null;
        }
        if (this.useRotary()) {
            this.axleHandler = this.createAxleHandler();
            this.axleOpt = LazyOptional.of(() -> this.axleHandler);
        } else {
            this.axleHandler = null;
        }
        if (this.fluids.length != 0) {
            this.globalFluidHandler = this.createGlobalFluidHandler();
            this.globalFluidOpt = LazyOptional.of(() -> this.globalFluidHandler);
        } else {
            this.globalFluidHandler = null;
        }
        Arrays.fill(this.fluids, FluidStack.EMPTY);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.useRotary() && this.angleW != null) {
                this.angleW[0] = (float)((double)this.angleW[0] + (double)this.angleW[1] * 9.0 / Math.PI);
            }
        } else if (this.useHeat() && !this.initHeat) {
            this.heatHandler.init();
        }
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        if (this.useHeat()) {
            HeatUtil.addHeatInfo(chat, this.temp, HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c));
        }
        if (this.useRotary()) {
            RotaryUtil.addRotaryInfo(chat, this.motData, this.axleHandler.getMoInertia(), this.axleHandler.getRotationRatio(), true);
        }
    }

    protected double getMoInertia() {
        return 0.0;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        int i;
        super.func_189515_b(nbt);
        for (i = 0; i < 4; ++i) {
            nbt.func_74780_a("mot_" + i, this.motData[i]);
        }
        if (this.angleW != null) {
            nbt.func_74776_a("ang_w_0", this.angleW[0]);
            nbt.func_74776_a("ang_w_1", this.angleW[1]);
        }
        nbt.func_74757_a("init_heat", this.initHeat);
        nbt.func_74780_a("temp", this.temp);
        for (i = 0; i < this.fluids.length; ++i) {
            if (this.fluids[i] == null) continue;
            CompoundNBT fluidNBT = new CompoundNBT();
            this.fluids[i].writeToNBT(fluidNBT);
            nbt.func_218657_a("fluid_" + i, (INBT)fluidNBT);
        }
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        int i;
        super.func_230337_a_(state, nbt);
        for (i = 0; i < 4; ++i) {
            this.motData[i] = nbt.func_74769_h("mot_" + i);
        }
        if (this.angleW != null) {
            this.angleW[0] = nbt.func_74760_g("ang_w_0");
            this.angleW[1] = nbt.func_74760_g("ang_w_1");
        }
        this.initHeat = nbt.func_74767_n("init_heat");
        this.temp = nbt.func_74769_h("temp");
        for (i = 0; i < this.fluids.length; ++i) {
            if (!nbt.func_74764_b("fluid_" + i)) continue;
            this.fluids[i] = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("fluid_" + i));
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.angleW != null) {
            nbt.func_74776_a("ang_w_0", this.angleW[0]);
            nbt.func_74776_a("ang_w_1", this.angleW[1]);
        }
        return nbt;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.heatOpt != null) {
            this.heatOpt.invalidate();
        }
        if (this.axleOpt != null) {
            this.axleOpt.invalidate();
        }
        if (this.globalFluidOpt != null) {
            this.globalFluidOpt.invalidate();
        }
    }

    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity sendingPlayer) {
        if (identifier == 0 && this.angleW != null) {
            float angle = Float.intBitsToFloat((int)(message & 0xFFFFFFFFL));
            this.angleW[0] = Math.abs(angle - this.angleW[0]) > 5.0f ? angle : this.angleW[0];
            this.angleW[1] = Float.intBitsToFloat((int)(message >>> 32));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side == null && this.globalFluidOpt != null) {
            return this.globalFluidOpt;
        }
        if (cap == Capabilities.HEAT_CAPABILITY && side == null) {
            return this.heatOpt;
        }
        if (cap == Capabilities.AXLE_CAPABILITY && side == null) {
            return this.axleOpt;
        }
        return super.getCapability(cap, side);
    }

    protected class AngleAxleHandler
    extends AxleHandler {
        public AngleAxleHandler() {
            ModuleTE.this.angleW = new float[2];
        }

        @Override
        public float getAngle(float partialTicks) {
            return this.axis == null ? 0.0f : this.axis.getAngle(this.rotRatio, partialTicks, this.renderOffset, 22.5f);
        }
    }

    protected class AxleHandler
    implements IAxleHandler {
        public double rotRatio;
        public byte updateKey;
        public boolean renderOffset;
        public IAxisHandler axis;

        protected AxleHandler() {
        }

        @Override
        public double[] getMotionData() {
            return ModuleTE.this.motData;
        }

        @Override
        public void propogate(IAxisHandler masterIn, byte key, double rotRatioIn, double lastRadius, boolean renderOffset) {
            if (key == this.updateKey || masterIn.addToList(this)) {
                return;
            }
            this.rotRatio = rotRatioIn == 0.0 ? 1.0 : rotRatioIn;
            this.renderOffset = renderOffset;
            this.updateKey = key;
            this.axis = masterIn;
        }

        @Override
        public double getMoInertia() {
            return ModuleTE.this.getMoInertia();
        }

        @Override
        public double getRotationRatio() {
            return this.rotRatio;
        }

        @Override
        public void markChanged() {
            ModuleTE.this.func_70296_d();
        }

        @Override
        public float getAngle(float partialTicks) {
            return 0.0f;
        }

        @Override
        public void disconnect() {
            this.axis = null;
        }
    }

    protected class HeatHandler
    implements IHeatHandler {
        protected HeatHandler() {
        }

        public void init() {
            if (!ModuleTE.this.initHeat) {
                ModuleTE.this.temp = HeatUtil.convertBiomeTemp(ModuleTE.this.field_145850_b, ModuleTE.this.field_174879_c);
                ModuleTE.this.initHeat = true;
                ModuleTE.this.func_70296_d();
            }
        }

        @Override
        public double getTemp() {
            this.init();
            return ModuleTE.this.temp;
        }

        @Override
        public void setTemp(double tempIn) {
            ModuleTE.this.initHeat = true;
            ModuleTE.this.temp = tempIn;
            ModuleTE.this.func_70296_d();
        }

        @Override
        public void addHeat(double heat) {
            this.init();
            ModuleTE.this.temp += heat;
            ModuleTE.this.func_70296_d();
        }
    }

    protected static class TankProperty {
        public final int capacity;
        public final boolean canFill;
        public final boolean canDrain;
        public final Predicate<Fluid> canAccept;

        public TankProperty(int capacity, boolean canFill, boolean canDrain) {
            this(capacity, canFill, canDrain, f -> canFill);
        }

        public TankProperty(int capacity, boolean canFill, boolean canDrain, @Nonnull Predicate<Fluid> canAccept) {
            this.capacity = capacity;
            this.canFill = canFill;
            this.canDrain = canDrain;
            this.canAccept = canAccept;
        }
    }

    protected class FluidTankHandler
    extends FluidHandler
    implements IFluidTank {
        public FluidTankHandler(int tank) {
            super(tank);
            assert (tank >= 0);
        }

        @Nonnull
        public FluidStack getFluid() {
            return ModuleTE.this.fluids[this.tank];
        }

        public int getFluidAmount() {
            return ModuleTE.this.fluids[this.tank].getAmount();
        }

        public int getCapacity() {
            return ModuleTE.this.fluidProps[this.tank].capacity;
        }

        public boolean isFluidValid(FluidStack stack) {
            return ModuleTE.this.fluidProps[this.tank].canFill && ModuleTE.this.fluidProps[this.tank].canAccept.test(stack.getFluid());
        }
    }

    protected class FluidHandler
    implements IFluidHandler {
        protected final int tank;

        public FluidHandler(int tank) {
            this.tank = tank;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.tank < 0) {
                for (int i = 0; i < ModuleTE.this.fluids.length; ++i) {
                    if (resource.isEmpty() || !this.isFluidValid(i, resource) || !ModuleTE.this.fluids[i].isEmpty() && !ModuleTE.this.fluids[i].isFluidEqual(resource)) continue;
                    int change = Math.min(ModuleTE.this.fluidProps[i].capacity - ModuleTE.this.fluids[i].getAmount(), resource.getAmount());
                    if (action == IFluidHandler.FluidAction.EXECUTE && change > 0) {
                        int prevAmount = ModuleTE.this.fluids[i].getAmount();
                        ModuleTE.this.fluids[i] = resource.copy();
                        ModuleTE.this.fluids[i].setAmount(prevAmount + change);
                        ModuleTE.this.func_70296_d();
                    }
                    return change;
                }
            } else if (!resource.isEmpty() && this.isFluidValid(this.tank, resource) && (ModuleTE.this.fluids[this.tank].isEmpty() || ModuleTE.this.fluids[this.tank].isFluidEqual(resource))) {
                int change = Math.min(ModuleTE.this.fluidProps[this.tank].capacity - ModuleTE.this.fluids[this.tank].getAmount(), resource.getAmount());
                if (action == IFluidHandler.FluidAction.EXECUTE && change >= 0) {
                    int prevAmount = ModuleTE.this.fluids[this.tank].getAmount();
                    ModuleTE.this.fluids[this.tank] = resource.copy();
                    ModuleTE.this.fluids[this.tank].setAmount(prevAmount + change);
                    ModuleTE.this.func_70296_d();
                }
                return change;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            if (this.tank < 0) {
                for (int i = 0; i < ModuleTE.this.fluids.length; ++i) {
                    if (!ModuleTE.this.fluidProps[i].canDrain || !resource.isFluidEqual(ModuleTE.this.fluids[i])) continue;
                    int change = Math.min(ModuleTE.this.fluids[i].getAmount(), resource.getAmount());
                    if (action == IFluidHandler.FluidAction.EXECUTE && change >= 0) {
                        ModuleTE.this.fluids[i].shrink(change);
                        ModuleTE.this.func_70296_d();
                    }
                    FluidStack out = resource.copy();
                    out.setAmount(change);
                    return out;
                }
                return FluidStack.EMPTY;
            }
            if (ModuleTE.this.fluidProps[this.tank].canDrain && resource.isFluidEqual(ModuleTE.this.fluids[this.tank])) {
                int change = Math.min(ModuleTE.this.fluids[this.tank].getAmount(), resource.getAmount());
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    ModuleTE.this.fluids[this.tank].shrink(change);
                    ModuleTE.this.func_70296_d();
                }
                FluidStack out = resource.copy();
                out.setAmount(change);
                return out;
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (maxDrain <= 0) {
                return FluidStack.EMPTY;
            }
            if (this.tank < 0) {
                for (int i = 0; i < ModuleTE.this.fluids.length; ++i) {
                    if (!ModuleTE.this.fluidProps[i].canDrain || ModuleTE.this.fluids[i].isEmpty()) continue;
                    int change = Math.min(ModuleTE.this.fluids[i].getAmount(), maxDrain);
                    FluidStack content = ModuleTE.this.fluids[i].copy();
                    content.setAmount(change);
                    if (action == IFluidHandler.FluidAction.EXECUTE) {
                        ModuleTE.this.fluids[i].shrink(change);
                        ModuleTE.this.func_70296_d();
                    }
                    return content;
                }
                return FluidStack.EMPTY;
            }
            if (ModuleTE.this.fluidProps[this.tank].canDrain && !ModuleTE.this.fluids[this.tank].isEmpty()) {
                int change = Math.min(ModuleTE.this.fluids[this.tank].getAmount(), maxDrain);
                FluidStack content = ModuleTE.this.fluids[this.tank].copy();
                content.setAmount(change);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    ModuleTE.this.fluids[this.tank].shrink(change);
                    ModuleTE.this.func_70296_d();
                }
                return content;
            }
            return FluidStack.EMPTY;
        }

        public int getTanks() {
            return this.tank < 0 ? ModuleTE.this.fluids.length : 1;
        }

        protected int calcTank(int rawTank) {
            if (this.tank < 0) {
                return rawTank;
            }
            return this.tank;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return ModuleTE.this.fluids[this.calcTank(tank)];
        }

        public int getTankCapacity(int tank) {
            return ModuleTE.this.fluidProps[this.calcTank((int)tank)].capacity;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return ModuleTE.this.fluidProps[this.calcTank((int)tank)].canFill && ModuleTE.this.fluidProps[this.calcTank((int)tank)].canAccept.test(stack.getFluid());
        }
    }
}

