/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads;

import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.SafeCallable;
import com.Da_Technomancer.crossroads.API.packets.SendGoggleConfigureToServer;
import com.Da_Technomancer.crossroads.API.technomancy.EnumGoggleLenses;
import com.Da_Technomancer.crossroads.Crossroads;
import com.Da_Technomancer.crossroads.Keys;
import com.Da_Technomancer.crossroads.integration.curios.CurioHelper;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.technomancy.BeamCage;
import com.Da_Technomancer.crossroads.items.technomancy.BeamUsingItem;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.render.IVisualEffect;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class EventHandlerClient {
    private static final Random RAND = new Random();
    private static final ResourceLocation MAGIC_BAR_BACKGROUND = new ResourceLocation("crossroads", "textures/gui/magic_info_back.png");
    private static final ResourceLocation MAGIC_BAR_FOREGROUND = new ResourceLocation("crossroads", "textures/gui/magic_info_front.png");
    private static final ResourceLocation COLOR_SHEET = new ResourceLocation("crossroads", "textures/block/color_sheet.png");

    @SubscribeEvent
    public void drawFieldsAndBeams(RenderWorldLastEvent e) {
        Minecraft game = Minecraft.func_71410_x();
        if (!SafeCallable.effectsToRender.isEmpty()) {
            game.func_213239_aq().func_76320_a("Crossroads: Visual Effects Draw");
            MatrixStack matrix = e.getMatrixStack();
            matrix.func_227860_a_();
            Vector3d cameraPos = CRRenderUtil.getCameraPos();
            matrix.func_227861_a_(-cameraPos.field_72450_a, -cameraPos.field_72448_b, -cameraPos.field_72449_c);
            ArrayList<IVisualEffect> toRemove = new ArrayList<IVisualEffect>();
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            long worldTime = game.field_71441_e.func_82737_E();
            float partialTicks = e.getPartialTicks();
            for (IVisualEffect effect : SafeCallable.effectsToRender) {
                matrix.func_227860_a_();
                if (effect.render(matrix, (IRenderTypeBuffer)buffer, worldTime, partialTicks, RAND)) {
                    toRemove.add(effect);
                }
                matrix.func_227865_b_();
            }
            SafeCallable.effectsToRender.removeAll(toRemove);
            buffer.func_228461_a_();
            matrix.func_227865_b_();
            game.func_213239_aq().func_76319_b();
        }
    }

    private static void handleGoggleGlowing(Minecraft game) {
        if (game.field_71441_e.func_82737_E() % 5L == 0L) {
            ItemStack helmet = Minecraft.func_71410_x().field_71439_g.func_184582_a(EquipmentSlotType.HEAD);
            boolean doGlowing = helmet.func_77973_b() == CRItems.moduleGoggles && helmet.func_77942_o() && helmet.func_77978_p().func_74767_n(EnumGoggleLenses.VOID.toString());
            for (Entity ent : game.field_71441_e.func_217416_b()) {
                CompoundNBT entNBT = ent.getPersistentData();
                if (entNBT == null) {
                    Crossroads.logger.info("Found entity with null persistent data! Report to the mod author of the mod that added the entity: %s", (Object)ent.func_200600_R().getRegistryName().toString());
                    continue;
                }
                if (!entNBT.func_74764_b("cr_glow")) {
                    ent.func_184195_f(false);
                } else {
                    entNBT.func_82580_o("cr_glow");
                }
                if (!doGlowing) continue;
                if (ent.func_225510_bt_()) {
                    entNBT.func_74757_a("cr_glow", true);
                    continue;
                }
                ent.func_184195_f(true);
            }
        }
    }

    @SubscribeEvent
    public void magicUsingItemOverlay(RenderGameOverlayEvent e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            ItemStack mainStack;
            int[] col;
            BufferBuilder buf;
            Tessellator tes;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            ItemStack cageStack = CurioHelper.getEquipped(CRItems.beamCage, (LivingEntity)player);
            if (!cageStack.func_190926_b()) {
                BeamUnit stored = BeamCage.getStored(cageStack);
                RenderSystem.pushMatrix();
                RenderSystem.pushLightingAttributes();
                RenderSystem.enableBlend();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MAGIC_BAR_BACKGROUND);
                tes = Tessellator.func_178181_a();
                buf = tes.func_178180_c();
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_225582_a_(0.0, 120.0, -3.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buf.func_225582_a_(117.0, 120.0, -3.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buf.func_225582_a_(117.0, 60.0, -3.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buf.func_225582_a_(0.0, 60.0, -3.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
                tes.func_78381_a();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(COLOR_SHEET);
                buf.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                for (int i = 0; i < 4; ++i) {
                    int extension = 72 * stored.getValues()[i] / 2048;
                    col = new int[4];
                    col[3] = 255;
                    col[i] = 255;
                    buf.func_225582_a_(24.0, (double)(84 + 9 * i), -2.0).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.25f + (float)i * 0.0625f, 0.0625f).func_181675_d();
                    buf.func_225582_a_((double)(24 + extension), (double)(84 + 9 * i), -2.0).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.3125f + (float)i * 0.0625f, 0.0625f).func_181675_d();
                    buf.func_225582_a_((double)(24 + extension), (double)(78 + 9 * i), -2.0).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.3125f + (float)i * 0.0625f, 0.0f).func_181675_d();
                    buf.func_225582_a_(24.0, (double)(78 + 9 * i), -2.0).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.25f + (float)i * 0.0625f, 0.0f).func_181675_d();
                }
                tes.func_78381_a();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MAGIC_BAR_FOREGROUND);
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_225582_a_(0.0, 120.0, -1.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buf.func_225582_a_(117.0, 120.0, -1.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buf.func_225582_a_(117.0, 60.0, -1.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buf.func_225582_a_(0.0, 60.0, -1.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
                tes.func_78381_a();
                Minecraft.func_71410_x().field_71466_p.func_238421_b_(e.getMatrixStack(), cageStack.func_200301_q().getString(), 16.0f, 65.0f, Color.DARK_GRAY.getRGB());
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                RenderSystem.popAttributes();
                RenderSystem.popMatrix();
            }
            if ((mainStack = player.func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof BeamUsingItem) {
                RenderSystem.pushMatrix();
                RenderSystem.pushLightingAttributes();
                RenderSystem.enableBlend();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MAGIC_BAR_BACKGROUND);
                tes = Tessellator.func_178181_a();
                buf = tes.func_178180_c();
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_225582_a_(0.0, 60.0, -3.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buf.func_225582_a_(117.0, 60.0, -3.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buf.func_225582_a_(117.0, 0.0, -3.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buf.func_225582_a_(0.0, 0.0, -3.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
                tes.func_78381_a();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(COLOR_SHEET);
                buf.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                byte[] settings = BeamUsingItem.getSetting(mainStack);
                for (int i = 0; i < 4; ++i) {
                    col = new int[4];
                    col[3] = 255;
                    col[i] = 255;
                    int extension = 9 * settings[i];
                    buf.func_225582_a_(24.0, (double)(24 + 9 * i), -2.0).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.25f + (float)i * 0.0625f, 0.0625f).func_181675_d();
                    buf.func_225582_a_((double)(24 + extension), (double)(24 + 9 * i), -2.0).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.3125f + (float)i * 0.0625f, 0.0625f).func_181675_d();
                    buf.func_225582_a_((double)(24 + extension), (double)(18 + 9 * i), -2.0).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.3125f + (float)i * 0.0625f, 0.0f).func_181675_d();
                    buf.func_225582_a_(24.0, (double)(18 + 9 * i), -2.0).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.25f + (float)i * 0.0625f, 0.0f).func_181675_d();
                }
                tes.func_78381_a();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MAGIC_BAR_FOREGROUND);
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_225582_a_(0.0, 60.0, -1.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buf.func_225582_a_(117.0, 60.0, -1.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buf.func_225582_a_(117.0, 0.0, -1.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buf.func_225582_a_(0.0, 0.0, -1.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
                tes.func_78381_a();
                Minecraft.func_71410_x().field_71466_p.func_238421_b_(e.getMatrixStack(), mainStack.func_200301_q().getString(), 16.0f, 5.0f, Color.DARK_GRAY.getRGB());
                RenderSystem.disableAlphaTest();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.popAttributes();
                RenderSystem.popMatrix();
            }
        }
    }

    @SubscribeEvent
    public void dilatePlayerTime(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            Minecraft game = Minecraft.func_71410_x();
            game.func_213239_aq().func_76320_a("Crossroads: Goggle Glowing Application");
            EventHandlerClient.handleGoggleGlowing(game);
            game.func_213239_aq().func_76319_b();
            if (SafeCallable.playerTickCount > 0) {
                for (int i = 0; i < SafeCallable.playerTickCount; ++i) {
                    player.func_70071_h_();
                }
                SafeCallable.playerTickCount = 0;
            }
        }
    }

    @SubscribeEvent
    public void elementKeys(InputEvent.KeyInputEvent e) {
        block4: {
            ItemStack helmet;
            block3: {
                ClientPlayerEntity play = Minecraft.func_71410_x().field_71439_g;
                if (Minecraft.func_71410_x().field_71462_r != null) {
                    return;
                }
                helmet = play.func_184582_a(EquipmentSlotType.HEAD);
                if (play.func_184614_ca().func_190926_b()) break block3;
                int key = Keys.controlEnergy.func_197976_a(e.getKey(), e.getScanCode()) ? 0 : (Keys.controlPotential.func_197976_a(e.getKey(), e.getScanCode()) ? 1 : (Keys.controlStability.func_197976_a(e.getKey(), e.getScanCode()) ? 2 : (Keys.controlVoid.func_197976_a(e.getKey(), e.getScanCode()) ? 3 : -1)));
                ItemStack stack = play.func_184614_ca();
                if (key == -1 || !(stack.func_77973_b() instanceof BeamUsingItem)) break block4;
                ((BeamUsingItem)stack.func_77973_b()).adjustSetting(Minecraft.func_71410_x().field_71439_g, stack, key, !play.func_225608_bj_());
                break block4;
            }
            if (helmet.func_77973_b() == CRItems.moduleGoggles && helmet.func_77942_o()) {
                CompoundNBT nbt = helmet.func_77978_p();
                for (EnumGoggleLenses lens : EnumGoggleLenses.values()) {
                    KeyBinding key = lens.getKey();
                    if (key == null || !key.func_151468_f() || !key.func_151470_d() || !nbt.func_74764_b(lens.toString())) continue;
                    CRPackets.channel.sendToServer((Object)new SendGoggleConfigureToServer(lens, !nbt.func_74767_n(lens.toString())));
                    break;
                }
            }
        }
    }
}

