/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.alchemy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.alchemy.EnumContainerType;
import com.Da_Technomancer.crossroads.API.alchemy.IChemicalHandler;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.alchemy.ReagentPumpTileEntity;
import com.Da_Technomancer.essentials.ESConfig;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class ReagentPump
extends ContainerBlock {
    private static final double SIZE = 5.0;
    private static final double CORE_SIZE = 4.0;
    protected static final VoxelShape[] SHAPES = new VoxelShape[16];
    private final boolean crystal;

    public ReagentPump(boolean crystal) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200947_a(SoundType.field_185853_f).func_200943_b(0.5f));
        this.crystal = crystal;
        String name = (crystal ? "crystal_" : "") + "reagent_pump";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ReagentPumpTileEntity(!this.crystal);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (ESConfig.isWrench((ItemStack)playerIn.func_184586_b(hand))) {
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, (BlockState)state.func_235896_a_((Property)CRProperties.ACTIVE));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CRProperties.ACTIVE, CRProperties.HAS_MATCH_SIDES[2], CRProperties.HAS_MATCH_SIDES[3], CRProperties.HAS_MATCH_SIDES[4], CRProperties.HAS_MATCH_SIDES[5]});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int index = 0;
        for (int i = 2; i < 5; ++i) {
            index |= (Boolean)state.func_177229_b((Property)CRProperties.HAS_MATCH_SIDES[i]) != false ? 1 << i - 2 : 0;
        }
        return SHAPES[index];
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean[] connect = new boolean[6];
        EnumContainerType contType = this.crystal ? EnumContainerType.CRYSTAL : EnumContainerType.GLASS;
        for (int i = 2; i < 6; ++i) {
            LazyOptional otherOpt;
            TileEntity te = context.func_195991_k().func_175625_s(context.func_195995_a().func_177972_a(Direction.func_82600_a((int)i)));
            if (te == null || !(otherOpt = te.getCapability(Capabilities.CHEMICAL_CAPABILITY, Direction.func_82600_a((int)i).func_176734_d())).isPresent() || !((IChemicalHandler)otherOpt.orElseThrow(NullPointerException::new)).getChannel(Direction.func_82600_a((int)i)).connectsWith(contType)) continue;
            connect[i] = true;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)CRProperties.HAS_MATCH_SIDES[2], (Comparable)Boolean.valueOf(connect[2]))).func_206870_a((Property)CRProperties.HAS_MATCH_SIDES[3], (Comparable)Boolean.valueOf(connect[3]))).func_206870_a((Property)CRProperties.HAS_MATCH_SIDES[4], (Comparable)Boolean.valueOf(connect[4]))).func_206870_a((Property)CRProperties.HAS_MATCH_SIDES[5], (Comparable)Boolean.valueOf(connect[5]));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos pos, BlockPos facingPos) {
        boolean connect;
        LazyOptional otherOpt;
        TileEntity te = worldIn.func_175625_s(facingPos);
        TileEntity thisTE = worldIn.func_175625_s(pos);
        boolean bl = thisTE instanceof ReagentPumpTileEntity && te != null && (otherOpt = te.getCapability(Capabilities.CHEMICAL_CAPABILITY, facing.func_176734_d())).isPresent() && ((IChemicalHandler)otherOpt.orElseThrow(NullPointerException::new)).getChannel(facing).connectsWith(this.crystal ? EnumContainerType.CRYSTAL : EnumContainerType.GLASS) ? true : (connect = false);
        if (facing.func_176740_k() != Direction.Axis.Y) {
            BooleanProperty prop = CRProperties.HAS_MATCH_SIDES[facing.func_176745_a()];
            return (BlockState)stateIn.func_206870_a((Property)prop, (Comparable)Boolean.valueOf(connect));
        }
        return stateIn;
    }

    static {
        double sizeN = 11.0;
        VoxelShape core = ReagentPump.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape[] pieces = new VoxelShape[]{ReagentPump.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0), ReagentPump.func_208617_a((double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0, (double)11.0), ReagentPump.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0), ReagentPump.func_208617_a((double)16.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0)};
        for (int i = 0; i < 16; ++i) {
            VoxelShape comp = core;
            for (int j = 0; j < 4; ++j) {
                if ((i & 1 << j) == 0) continue;
                comp = VoxelShapes.func_197872_a((VoxelShape)comp, (VoxelShape)pieces[j]);
            }
            ReagentPump.SHAPES[i] = comp;
        }
    }
}

