/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.beams;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.beams.LensFrameTileEntity;
import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.IReadable;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class LensFrame
extends ContainerBlock
implements IReadable {
    private static final VoxelShape[] SHAPE = new VoxelShape[3];

    public LensFrame() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.0f));
        String name = "lens_frame";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE[((Direction.Axis)state.func_177229_b((Property)ESProperties.AXIS)).ordinal()];
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new LensFrameTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)ESProperties.AXIS, (Comparable)context.func_196010_d().func_176740_k());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ESProperties.AXIS});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (ESConfig.isWrench((ItemStack)stack)) {
                worldIn.func_175656_a(pos, (BlockState)state.func_235896_a_((Property)ESProperties.AXIS));
            } else {
                int id;
                TileEntity te = worldIn.func_175625_s(pos);
                if (!(te instanceof LensFrameTileEntity)) {
                    return ActionResultType.SUCCESS;
                }
                LensFrameTileEntity lens = (LensFrameTileEntity)te;
                ItemStack held = lens.getItem();
                if (!held.func_190926_b()) {
                    ItemEntity dropped;
                    if (!playerIn.field_71071_by.func_70441_a(held) && (dropped = playerIn.func_71019_a(held, false)) != null) {
                        dropped.func_174868_q();
                        dropped.func_200217_b(playerIn.func_110124_au());
                    }
                    lens.setContents(0);
                } else if (!stack.func_190926_b() && (id = lens.getIDFromItem(stack)) != 0) {
                    lens.setContents(id);
                    stack.func_190918_g(1);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te = world.func_175625_s(pos);
        if (newState.func_177230_c() != this && te instanceof LensFrameTileEntity) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)((LensFrameTileEntity)te).getItem());
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        return RedstoneUtil.clampToVanilla((float)this.read(world, pos, blockState));
    }

    public float read(World world, BlockPos pos, BlockState blockState) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LensFrameTileEntity) {
            return ((LensFrameTileEntity)te).getRedstone();
        }
        return 0.0f;
    }

    static {
        LensFrame.SHAPE[0] = LensFrame.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
        LensFrame.SHAPE[1] = LensFrame.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
        LensFrame.SHAPE[2] = LensFrame.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    }
}

