/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.heat;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.heat.IHeatHandler;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.heat.HeatReservoirTileEntity;
import com.Da_Technomancer.essentials.blocks.redstone.IReadable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

public class HeatReservoir
extends ContainerBlock
implements IReadable {
    public HeatReservoir() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f));
        String name = "heat_reservoir";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new HeatReservoirTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.heat_battery.info"));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.heat_battery.reds"));
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("temp")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.heat_battery.temp", new Object[]{CRConfig.formatVal(nbt.func_74769_h("temp"))}));
        }
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stackIn) {
        if (!(te instanceof HeatReservoirTileEntity)) {
            super.func_180657_a(worldIn, player, pos, state, te, stackIn);
        } else {
            player.func_71020_j(0.005f);
            ItemStack stack = new ItemStack((IItemProvider)this, 1);
            stack.func_77982_d(((HeatReservoirTileEntity)te).getDropNBT());
            HeatReservoir.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        LazyOptional heatOpt;
        TileEntity te;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && (te = world.func_175625_s(pos)) instanceof HeatReservoirTileEntity && (heatOpt = te.getCapability(Capabilities.HEAT_CAPABILITY, null)).isPresent()) {
            ((IHeatHandler)heatOpt.orElseThrow(NullPointerException::new)).setTemp(nbt.func_74769_h("temp"));
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        LazyOptional heatOpt;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && (heatOpt = te.getCapability(Capabilities.HEAT_CAPABILITY, null)).isPresent()) {
            return (int)Math.max(15L, Math.round(HeatUtil.toKelvin(((IHeatHandler)heatOpt.orElseThrow(NullPointerException::new)).getTemp())));
        }
        return 0;
    }

    public float read(World world, BlockPos pos, BlockState state) {
        LazyOptional heatOpt;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && (heatOpt = te.getCapability(Capabilities.HEAT_CAPABILITY, null)).isPresent()) {
            return Math.round(HeatUtil.toKelvin(((IHeatHandler)heatOpt.orElseThrow(NullPointerException::new)).getTemp()));
        }
        return 0.0f;
    }
}

