/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.rotary;

import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.MechanismTileEntity;
import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.redstone.IReadable;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public class Mechanism
extends ContainerBlock
implements IReadable {
    public Mechanism() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(1.0f).func_200947_a(SoundType.field_185852_e).func_208770_d());
        String name = "mechanism";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new MechanismTileEntity();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof MechanismTileEntity)) {
            return ItemStack.field_190927_a;
        }
        MechanismTileEntity mte = (MechanismTileEntity)te;
        Vector3d relVec = target.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        for (int i = 0; i < 7; ++i) {
            if (mte.boundingBoxes[i] == null || !Mechanism.voxelContains(mte.boundingBoxes[i], relVec)) continue;
            return mte.members[i].getDrop(mte.mats[i]);
        }
        return ItemStack.field_190927_a;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof MechanismTileEntity) {
            return this.func_220071_b(state, worldIn, pos, context);
        }
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof MechanismTileEntity) {
            MechanismTileEntity mte = (MechanismTileEntity)te;
            VoxelShape shape = VoxelShapes.func_197880_a();
            for (VoxelShape s : mte.boundingBoxes) {
                if (s == null) continue;
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)s);
            }
            return shape;
        }
        return VoxelShapes.func_197880_a();
    }

    public boolean removedByPlayer(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        RotaryUtil.increaseMasterKey(false);
        return super.removedByPlayer(state, worldIn, pos, player, willHarvest, fluid);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (te instanceof MechanismTileEntity) {
            MechanismTileEntity mte = (MechanismTileEntity)te;
            for (int i = 0; i < 7; ++i) {
                if (mte.members[i] == null) continue;
                drops.add(mte.members[i].getDrop(mte.mats[i]));
            }
        }
        return drops;
    }

    private int getAimedSide(MechanismTileEntity te, Vector3d start, Vector3d end) {
        double minDist = 3.4028234663852886E38;
        int target = -1;
        for (int i = 0; i < te.boundingBoxes.length; ++i) {
            double dist;
            BlockRayTraceResult res;
            if (te.boundingBoxes[i] == null || (res = te.boundingBoxes[i].func_212433_a(start, end, BlockPos.field_177992_a)) == null || !((dist = res.func_216347_e().func_178788_d(start).func_189985_c()) < minDist)) continue;
            minDist = dist;
            target = i;
        }
        return target;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.func_220069_a(state, world, pos, (Block)this, pos, false);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        RotaryUtil.increaseMasterKey(true);
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity rawTE = worldIn.func_175625_s(pos);
        if (!(rawTE instanceof MechanismTileEntity)) {
            return;
        }
        MechanismTileEntity te = (MechanismTileEntity)rawTE;
        for (Direction side : Direction.values()) {
            if (te.members[side.func_176745_a()] == null || RotaryUtil.solidToGears(worldIn, pos.func_177972_a(side), side.func_176734_d())) continue;
            Mechanism.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)te.members[side.func_176745_a()].getDrop(te.mats[side.func_176745_a()]));
            te.setMechanism(side.func_176745_a(), null, null, null, false);
        }
        if (te.members[0] == null && te.members[1] == null && te.members[2] == null && te.members[3] == null && te.members[4] == null && te.members[5] == null && te.members[6] == null) {
            worldIn.func_175655_b(pos, false);
        }
        te.updateRedstone();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity te;
        if (ESConfig.isWrench((ItemStack)player.func_184586_b(hand)) && (te = worldIn.func_175625_s(pos)) instanceof MechanismTileEntity) {
            Vector3d end;
            MechanismTileEntity gear = (MechanismTileEntity)te;
            double reDist = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
            Vector3d start = new Vector3d(player.field_70169_q, player.field_70167_r + (double)player.func_70047_e(), player.field_70166_s).func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            int out = this.getAimedSide(gear, start, end = start.func_72441_c(player.func_70676_i((float)0.0f).field_72450_a * reDist, player.func_70676_i((float)0.0f).field_72448_b * reDist, player.func_70676_i((float)0.0f).field_72449_c * reDist));
            if (out == -1) {
                return ActionResultType.FAIL;
            }
            if (!worldIn.field_72995_K) {
                if (!player.func_184812_l_()) {
                    Mechanism.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)gear.members[out].getDrop(gear.mats[out]));
                }
                gear.setMechanism(out, null, null, null, false);
                if (gear.members[0] == null && gear.members[1] == null && gear.members[2] == null && gear.members[3] == null && gear.members[4] == null && gear.members[5] == null && gear.members[6] == null) {
                    worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
            }
            RotaryUtil.increaseMasterKey(!worldIn.field_72995_K);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return RedstoneUtil.clampToVanilla((float)this.read(worldIn, pos, blockState));
    }

    public float read(World world, BlockPos pos, BlockState blockState) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof MechanismTileEntity ? ((MechanismTileEntity)te).getRedstone() : 0.0f;
    }

    public static boolean voxelContains(VoxelShape shape, Vector3d point) {
        boolean[] contained = new boolean[1];
        shape.func_197755_b((xMin, yMin, zMin, xMax, yMax, zMax) -> {
            if (!contained[0]) {
                contained[0] = xMin <= point.field_72450_a && xMax >= point.field_72450_a && yMin <= point.field_72448_b && yMax >= point.field_72448_b && zMin <= point.field_72449_c && zMax >= point.field_72449_c;
            }
        });
        return contained[0];
    }
}

