/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.rotary;

import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.rotary.WindingTableTileEntity;
import com.Da_Technomancer.essentials.blocks.redstone.IReadable;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class WindingTable
extends ContainerBlock
implements IReadable {
    public WindingTable() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_200947_a(SoundType.field_185852_e));
        String name = "winding_table";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof INamedContainerProvider) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new WindingTableTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != this) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)world.func_175625_s(pos)));
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof WindingTableTileEntity) {
            ((WindingTableTileEntity)te).redstoneTrigger(RedstoneUtil.getRedstoneAtPos((World)worldIn, (BlockPos)pos) > 0);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.func_220069_a(state, worldIn, pos, (Block)this, pos, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.winding_table.desc", new Object[]{CRConfig.formatVal(50.0)}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.winding_table.reds", new Object[]{CRConfig.formatVal(0.2)}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.winding_table.counter", new Object[]{CRConfig.formatVal((Double)CRConfig.windingResist.get())}));
        if (((Boolean)CRConfig.windingDestroy.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.winding_table.destroy"));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.winding_table.loss"));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.winding_table.circuit"));
    }

    public float read(World world, BlockPos pos, BlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof WindingTableTileEntity) {
            return (float)((WindingTableTileEntity)te).getStoredSpeed();
        }
        return 0.0f;
    }
}

