/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.technomancy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.technomancy.FluxUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.technomancy.GatewayFrameTileEntity;
import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.redstone.IReadable;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class GatewayFrame
extends ContainerBlock
implements IReadable {
    public GatewayFrame() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_200947_a(SoundType.field_185852_e));
        String name = "gateway_frame";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)CRProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new GatewayFrameTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return (Boolean)state.func_177229_b((Property)CRProperties.ACTIVE) != false ? BlockRenderType.ENTITYBLOCK_ANIMATED : BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CRProperties.ACTIVE});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        TileEntity te;
        ItemStack held = player.func_184586_b(hand);
        if (((Boolean)state.func_177229_b((Property)CRProperties.ACTIVE)).booleanValue()) {
            return FluxUtil.handleFluxLinking(world, pos, held, player);
        }
        if (ESConfig.isWrench((ItemStack)held) && (te = world.func_175625_s(pos)) instanceof GatewayFrameTileEntity) {
            ((GatewayFrameTileEntity)te).assemble();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te = world.func_175625_s(pos);
        if (newState.func_177230_c() != state.func_177230_c() && te instanceof GatewayFrameTileEntity) {
            ((GatewayFrameTileEntity)te).dismantle();
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.gateway.desc"));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.gateway.dial"));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.gateway.proc"));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.gateway.flux", new Object[]{4}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.inertia", new Object[]{0}));
    }

    public boolean func_149740_M(BlockState state) {
        return (Boolean)state.func_177229_b((Property)CRProperties.ACTIVE);
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return RedstoneUtil.clampToVanilla((float)this.read(world, pos, state));
    }

    public float read(World world, BlockPos pos, BlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GatewayFrameTileEntity) {
            EnumBeamAlignments[] chev = ((GatewayFrameTileEntity)te).chevrons;
            for (int i = 0; i < chev.length; ++i) {
                if (chev[i] != null) continue;
                return i;
            }
            return chev.length;
        }
        return 0.0f;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }
}

