/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.entity;

import com.Da_Technomancer.crossroads.API.alchemy.AlchemyUtil;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.items.CRItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
@ObjectHolder(value="crossroads")
public class EntityShell
extends ThrowableEntity
implements IRendersAsItem {
    @ObjectHolder(value="shell")
    public static EntityType<EntityShell> type = null;
    private static final DataParameter<Boolean> crystal = EntityDataManager.func_187226_a(EntityShell.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final ItemStack[] RENDER_STACK = new ItemStack[]{new ItemStack((IItemProvider)CRItems.shellGlass), new ItemStack((IItemProvider)CRItems.shellCrystal)};
    private ReagentMap contents;

    public EntityShell(EntityType<EntityShell> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityShell(World worldIn, ReagentMap contents, boolean isCrystal) {
        this(type, worldIn);
        this.contents = contents;
        this.field_70180_af.func_187227_b(crystal, (Object)isCrystal);
    }

    public EntityShell(World worldIn, LivingEntity throwerIn, ReagentMap contents, boolean isCrystal) {
        super(type, throwerIn, worldIn);
        this.contents = contents;
        this.field_70180_af.func_187227_b(crystal, (Object)isCrystal);
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.contents != null) {
                Vector3d hit = result.func_216347_e();
                AlchemyUtil.releaseChemical(this.field_70170_p, new BlockPos(hit.field_72450_a, hit.field_72448_b, hit.field_72449_c), this.contents);
            }
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(crystal, (Object)false);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.contents = ReagentMap.readFromNBT(nbt);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.contents != null) {
            this.contents.write(nbt);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_184543_l() {
        return (Boolean)this.field_70180_af.func_187225_a(crystal) != false ? RENDER_STACK[1] : RENDER_STACK[0];
    }
}

