/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.fluids;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.items.CRItems;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class GenericFluid
extends FlowingFluidBlock {
    private static final AbstractBlock.Properties BLOCK_PROP = AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e();
    private static final AbstractBlock.Properties BLOCK_PROP_HOT = AbstractBlock.Properties.func_200945_a((Material)Material.field_151587_i).func_200942_a().func_200943_b(100.0f).func_222380_e().func_235838_a_(state -> 15);
    private static final Item.Properties BUCKET_PROP = new Item.Properties().func_200919_a(Items.field_151133_ar).func_200917_a(1).func_200916_a(ItemGroup.field_78026_f);

    public static FluidData create(String name, boolean lavaLike, boolean gaseous) {
        FluidData data = new FluidData();
        Supplier<FlowingFluid> stillS = () -> data.still;
        Supplier<FlowingFluid> flowS = () -> data.flowing;
        Supplier<FlowingFluidBlock> blockS = () -> data.block;
        Supplier<Item> itemS = () -> data.bucket;
        data.still = new Still(name, stillS, flowS, blockS, itemS, lavaLike, gaseous);
        data.flowing = new Flowing(name, stillS, flowS, blockS, itemS, lavaLike, gaseous);
        data.bucket = (Item)new BucketItem(stillS, BUCKET_PROP).setRegistryName(name + "_bucket");
        data.block = new GenericFluid(name, stillS, lavaLike ? BLOCK_PROP_HOT : BLOCK_PROP);
        CRFluids.toRegister.add((Fluid)data.still);
        CRFluids.toRegister.add((Fluid)data.flowing);
        CRBlocks.toRegister.add((Block)data.block);
        CRItems.toRegister.add(data.bucket);
        return data;
    }

    protected GenericFluid(String name, Supplier<FlowingFluid> still, AbstractBlock.Properties prop) {
        super(still, prop);
        this.setRegistryName(name);
    }

    private static class Still
    extends ForgeFlowingFluid.Source {
        private Still(String name, Supplier<? extends Fluid> stillSupplier, Supplier<? extends Fluid> flowSupplier, Supplier<FlowingFluidBlock> blockSupplier, Supplier<Item> bucketSupplier, boolean hot, boolean gaseous) {
            super(new ForgeFlowingFluid.Properties(stillSupplier, flowSupplier, FluidAttributes.builder((ResourceLocation)new ResourceLocation("crossroads", "block/" + name + "_still"), (ResourceLocation)new ResourceLocation("crossroads", "block/" + name + "_flow")).luminosity(hot ? 15 : 0).density(gaseous ? -100 : 1000).temperature(hot ? 3000 : 300).viscosity(gaseous ? 500 : (hot ? 6000 : 1000))).block(blockSupplier).bucket(bucketSupplier));
            this.setRegistryName(name);
        }
    }

    private static class Flowing
    extends ForgeFlowingFluid.Flowing {
        private Flowing(String name, Supplier<? extends Fluid> stillSupplier, Supplier<? extends Fluid> flowSupplier, Supplier<FlowingFluidBlock> blockSupplier, Supplier<Item> bucketSupplier, boolean hot, boolean gaseous) {
            super(new ForgeFlowingFluid.Properties(stillSupplier, flowSupplier, FluidAttributes.builder((ResourceLocation)new ResourceLocation("crossroads", "block/" + name + "_still"), (ResourceLocation)new ResourceLocation("crossroads", "block/" + name + "_flow")).luminosity(hot ? 15 : 0).density(gaseous ? -100 : 1000).temperature(hot ? 3000 : 300).viscosity(gaseous ? 500 : (hot ? 6000 : 1000))).block(blockSupplier).bucket(bucketSupplier));
            this.setRegistryName("flowing_" + name);
        }
    }

    public static class FluidData {
        public FlowingFluid still;
        public FlowingFluid flowing;
        public FlowingFluidBlock block;
        public Item bucket;

        private FluidData() {
        }
    }
}

