/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.gui;

import com.Da_Technomancer.crossroads.API.AdvancementTracker;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.gui.container.ColorChartContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ColorChartScreen
extends ContainerScreen<ColorChartContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("crossroads", "textures/gui/container/color_chart_gui.png");
    private static final int xCENTER = 150;
    private static final int yCENTER = 150;
    private static final int RADIUS = 138;
    private TextFieldWidget searchBar;

    public ColorChartScreen(ColorChartContainer cont, PlayerInventory playerInv, ITextComponent name) {
        super((Container)cont, playerInv, name);
        this.field_146999_f = 300;
        this.field_147000_g = 300;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        AdvancementTracker.listen();
        this.searchBar = new TextFieldWidget(this.field_230712_o_, this.field_147003_i, this.field_147009_r + this.field_147000_g, this.field_146999_f, 18, (ITextComponent)new TranslationTextComponent("container.search_bar"));
        this.searchBar.func_146205_d(false);
        this.searchBar.func_146193_g(-1);
        this.searchBar.func_146204_h(-1);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146203_f(20);
        this.searchBar.func_200675_a(s -> {
            for (char c : s.toCharArray()) {
                if (Character.isAlphabetic(c)) continue;
                return false;
            }
            return true;
        });
        this.field_230705_e_.add(this.searchBar);
        this.func_212928_a((IGuiEventListener)this.searchBar);
    }

    private static Color getColor(int x, int y) {
        return Color.getHSBColor((float)(Math.atan2(y - 150, x - 150) / (Math.PI * 2)), (float)Math.min(Math.sqrt(Math.pow(x - 150, 2.0) + Math.pow(y - 150, 2.0)) / 138.0, 1.0), 1.0f);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        if (Math.pow(150 - mouseX + this.field_147003_i, 2.0) + Math.pow(150 - mouseY + this.field_147009_r, 2.0) <= 19044.0) {
            Color col = ColorChartScreen.getColor(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            EnumBeamAlignments elem = EnumBeamAlignments.getAlignment(col);
            ArrayList<StringTextComponent> tooltip = new ArrayList<StringTextComponent>(2);
            if (elem.isDiscovered(this.field_213127_e.field_70458_d)) {
                tooltip.add(new StringTextComponent(elem.getLocalName(false)));
            } else {
                tooltip.add(new StringTextComponent("???"));
            }
            tooltip.add(new StringTextComponent("R: " + col.getRed() + ", G: " + col.getGreen() + ", B: " + col.getBlue()));
            this.renderToolTip(matrix, tooltip, mouseX, mouseY, this.field_230712_o_);
        }
        this.searchBar.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        ColorChartScreen.func_238463_a_((MatrixStack)matrix, (int)i, (int)j, (float)300.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)1200, (int)1200);
        String search = this.searchBar.func_146179_b().toUpperCase();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        for (EnumBeamAlignments elem : EnumBeamAlignments.values()) {
            if (!elem.isDiscovered(this.field_213127_e.field_70458_d) || !search.isEmpty() && !elem.getLocalName(false).toLowerCase(Locale.US).startsWith(search.toLowerCase(Locale.US))) continue;
            int imageIndex = elem.ordinal() + 2;
            ColorChartScreen.func_238463_a_((MatrixStack)matrix, (int)this.field_147003_i, (int)this.field_147009_r, (float)(this.field_146999_f * (imageIndex % 4)), (float)(this.field_146999_f * (imageIndex / 4)), (int)this.field_146999_f, (int)this.field_147000_g, (int)1200, (int)1200);
        }
    }

    public boolean func_231044_a_(double x, double y, int button) {
        return this.searchBar.func_231044_a_(x, y, button) || super.func_231044_a_(x, y, button);
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        for (IGuiEventListener gui : this.field_230705_e_) {
            if (!gui.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) continue;
            return true;
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean func_231042_a_(char key, int keyCode) {
        for (IGuiEventListener gui : this.field_230705_e_) {
            if (!gui.func_231042_a_(key, keyCode)) continue;
            return true;
        }
        return super.func_231042_a_(key, keyCode);
    }

    protected void func_230451_b_(MatrixStack matrix, int p_230451_2_, int p_230451_3_) {
        this.field_230712_o_.func_238422_b_(matrix, (ITextProperties)this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
    }
}

