/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.gui.container;

import com.Da_Technomancer.crossroads.API.EnumPath;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.recipes.DetailedCrafterRec;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class DetailedCrafterContainer
extends RecipeBookContainer<CraftingInventory> {
    @ObjectHolder(value="detailed_crafter")
    private static ContainerType<DetailedCrafterContainer> type = null;
    private static final ITag<Item>[] unlockKeys = new ITag[3];
    private static final ITag<Item> fillerMats = ItemTags.func_199901_a((String)"crossroads:path_unlock_filler");
    private final CraftingInventory inInv = new CraftingInventory((Container)this, 3, 3);
    private final CraftResultInventory outInv = new CraftResultInventory();
    private final World world;
    private final PlayerEntity player;
    private final boolean fake;
    @Nullable
    private final BlockPos pos;
    private byte lastUnlock = (byte)-1;

    public DetailedCrafterContainer(int id, PlayerInventory playerInv, PacketBuffer buf) {
        super(type, id);
        this.player = playerInv.field_70458_d;
        this.world = this.player.field_70170_p;
        this.fake = buf.readBoolean();
        this.pos = this.fake ? null : buf.func_179259_c();
        this.func_75146_a((Slot)new SlotCraftingFlexible(playerInv.field_70458_d, this.inInv, (IInventory)this.outInv, 0, 124, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.inInv, j + i * 3, 30 + j * 18, 17 + i * 18));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)playerInv, i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)playerInv, l, 8 + l * 18, 142));
        }
    }

    public void func_201771_a(RecipeItemHelper helper) {
        this.inInv.func_194018_a(helper);
    }

    public void func_201768_e() {
        this.inInv.func_174888_l();
        this.outInv.func_174888_l();
    }

    public boolean func_201769_a(IRecipe<? super CraftingInventory> recipeIn) {
        if (recipeIn instanceof DetailedCrafterRec) {
            return ((DetailedCrafterRec)recipeIn).getPath().isUnlocked(this.player) && recipeIn.func_77569_a((IInventory)this.inInv, this.player.field_70170_p);
        }
        return recipeIn.func_77569_a((IInventory)this.inInv, this.player.field_70170_p);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.func_193327_a(playerIn, this.world, (IInventory)this.inInv);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.fake || this.pos == null || playerIn.field_70170_p.func_180495_p(this.pos).func_177230_c() == CRBlocks.detailedCrafter && playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                itemstack1.func_77973_b().func_77622_d(itemstack1, this.world, playerIn);
                if (!this.func_75135_a(itemstack1, 10, 46, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 10 && index < 37 ? !this.func_75135_a(itemstack1, 37, 46, false) : (index >= 37 && index < 46 ? !this.func_75135_a(itemstack1, 10, 37, false) : !this.func_75135_a(itemstack1, 10, 46, false))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.outInv && super.func_94530_a(stack, slotIn);
    }

    public int func_201767_f() {
        return 0;
    }

    public int func_201770_g() {
        return this.inInv.func_174922_i();
    }

    public int func_201772_h() {
        return this.inInv.func_174923_h();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_203721_h() {
        return 10;
    }

    public void func_75130_a(IInventory inventoryIn) {
        for (EnumPath path : EnumPath.values()) {
            if (path.isUnlocked(this.player) || !path.pathGatePassed(this.player) || !this.unlockRecipe(path) || this.world.field_72995_K && this.lastUnlock == path.getIndex()) continue;
            if (this.world.field_72995_K) {
                this.lastUnlock = path.getIndex();
                this.playUnlockSound();
            } else {
                path.setUnlocked(this.player, true);
            }
            for (int i = 0; i < 9; ++i) {
                this.inInv.func_70298_a(i, 1);
            }
            return;
        }
        if (!this.world.field_72995_K) {
            ICraftingRecipe recipe;
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)this.player;
            ItemStack itemstack = ItemStack.field_190927_a;
            List recipes = this.world.func_199532_z().func_215370_b(CRRecipes.DETAILED_TYPE, (IInventory)this.inInv, this.world);
            Optional recipeOpt = recipes.stream().filter(rec -> rec.getPath().isUnlocked(this.player)).findFirst();
            if (!recipeOpt.isPresent()) {
                recipeOpt = this.world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.inInv, this.world);
            }
            if (recipeOpt.isPresent() && this.outInv.func_201561_a(this.world, serverplayerentity, (IRecipe)(recipe = (ICraftingRecipe)recipeOpt.get()))) {
                itemstack = recipe.func_77572_b((IInventory)this.inInv);
            }
            this.outInv.func_70299_a(0, itemstack);
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, itemstack));
        }
    }

    private boolean unlockRecipe(EnumPath path) {
        for (int i = 0; i < 9; ++i) {
            if (i == 4 || fillerMats.func_230235_a_((Object)this.inInv.func_70301_a(i).func_77973_b())) continue;
            return false;
        }
        return unlockKeys[path.getIndex()].func_230235_a_((Object)this.inInv.func_70301_a(4).func_77973_b());
    }

    private void playUnlockSound() {
        this.world.func_184133_a(this.player, this.player.func_233580_cy_(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 2.0f, 0.0f);
    }

    static {
        DetailedCrafterContainer.unlockKeys[0] = ItemTags.func_199901_a((String)"crossroads:technomancy_unlock_key");
        DetailedCrafterContainer.unlockKeys[1] = ItemTags.func_199901_a((String)"crossroads:alchemy_unlock_key");
        DetailedCrafterContainer.unlockKeys[2] = ItemTags.func_199901_a((String)"crossroads:witchcraft_unlock_key");
    }

    private static class SlotCraftingFlexible
    extends CraftingResultSlot {
        private final CraftingInventory craftMatrix;

        public SlotCraftingFlexible(PlayerEntity player, CraftingInventory craftingInventory, IInventory inventoryIn, int slotIndex, int xPosition, int yPosition) {
            super(player, craftingInventory, inventoryIn, slotIndex, xPosition, yPosition);
            this.craftMatrix = craftingInventory;
        }

        public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
            this.func_75208_c(stack);
            ForgeHooks.setCraftingPlayer((PlayerEntity)thePlayer);
            List recipes = thePlayer.field_70170_p.func_199532_z().func_215370_b(CRRecipes.DETAILED_TYPE, (IInventory)this.craftMatrix, thePlayer.field_70170_p);
            Optional recipeOpt = recipes.stream().filter(rec -> rec.getPath().isUnlocked(thePlayer)).findFirst();
            if (!recipeOpt.isPresent()) {
                recipeOpt = thePlayer.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftMatrix, thePlayer.field_70170_p);
            }
            if (recipeOpt.isPresent()) {
                NonNullList remaining = ((ICraftingRecipe)recipeOpt.get()).func_179532_b((IInventory)this.craftMatrix);
                for (int i = 0; i < remaining.size(); ++i) {
                    this.craftMatrix.func_70298_a(i, 1);
                    ItemStack remainStack = (ItemStack)remaining.get(i);
                    ItemStack invStack = this.craftMatrix.func_70301_a(i);
                    if (remainStack.func_190926_b()) continue;
                    if (invStack.func_190926_b()) {
                        this.craftMatrix.func_70299_a(i, (ItemStack)remaining.get(i));
                        continue;
                    }
                    if (BlockUtil.sameItem((ItemStack)invStack, (ItemStack)remainStack)) {
                        invStack.func_190917_f(remainStack.func_190916_E());
                        this.craftMatrix.func_70299_a(i, invStack);
                        continue;
                    }
                    if (thePlayer.field_71071_by.func_70441_a(remainStack)) continue;
                    thePlayer.func_71019_a(remainStack, false);
                }
            }
            return stack;
        }
    }
}

