/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.integration.JEI.JEICrossroadsPlugin;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.crafting.recipes.BlastFurnaceRec;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class BlastFurnaceCategory
implements IRecipeCategory<BlastFurnaceRec> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", "blast_furnace");
    private final IDrawable back;
    private final IDrawable slot;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic arrowStatic;
    private final IDrawable fluidOverlay;
    private final IDrawable icon;

    protected BlastFurnaceCategory(IGuiHelper guiHelper) {
        this.back = guiHelper.createBlankDrawable(180, 100);
        this.slot = guiHelper.getSlotDrawable();
        this.arrowStatic = guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 79, 35, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 176, 14, 24, 17), 40, IDrawableAnimated.StartDirection.LEFT, false);
        this.fluidOverlay = JEICrossroadsPlugin.createFluidOverlay(guiHelper);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRBlocks.blastFurnace, 1));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends BlastFurnaceRec> getRecipeClass() {
        return BlastFurnaceRec.class;
    }

    public String getTitle() {
        return CRBlocks.blastFurnace.func_235333_g_().getString();
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public void draw(BlastFurnaceRec recipe, MatrixStack matrix, double mouseX, double mouseY) {
        this.slot.draw(matrix, 54, 55);
        this.slot.draw(matrix, 130, 55);
        this.arrowStatic.draw(matrix, 78, 55);
        this.arrow.draw(matrix, 78, 55);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrix, MiscUtil.localize("crossroads.jei.blast_furnace.carbon", recipe.getSlag()), 10.0f, 10.0f, 0x404040);
    }

    public void setRecipe(IRecipeLayout layout, BlastFurnaceRec recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemGroup = layout.getItemStacks();
        IGuiFluidStackGroup fluidGroup = layout.getFluidStacks();
        itemGroup.init(0, true, 54, 55);
        itemGroup.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemGroup.init(1, false, 130, 55);
        itemGroup.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        fluidGroup.init(0, false, 110, 22, 16, 64, 1000, true, this.fluidOverlay);
        fluidGroup.set(0, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
        itemGroup.set(ingredients);
        fluidGroup.set(ingredients);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(BlastFurnaceRec recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutput());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)CRItems.slag, recipe.getSlag()));
    }
}

