/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.integration.JEI.JEICrossroadsPlugin;
import com.Da_Technomancer.crossroads.items.crafting.recipes.CopshowiumRec;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class CopshowiumCategory
implements IRecipeCategory<CopshowiumRec> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", "copshowium");
    private final IDrawable back;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic arrowStatic;
    private final IDrawable fluidOverlay;

    protected CopshowiumCategory(IGuiHelper guiHelper) {
        this.back = guiHelper.createBlankDrawable(180, 100);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRBlocks.copshowiumCreationChamber, 1));
        this.arrowStatic = guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 79, 35, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 176, 14, 24, 17), 40, IDrawableAnimated.StartDirection.LEFT, false);
        this.fluidOverlay = JEICrossroadsPlugin.createFluidOverlay(guiHelper);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends CopshowiumRec> getRecipeClass() {
        return CopshowiumRec.class;
    }

    public String getTitle() {
        return CRBlocks.copshowiumCreationChamber.func_235333_g_().getString();
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public void draw(CopshowiumRec rec, MatrixStack matrix, double mouseX, double mouseY) {
        if (rec.isFlux()) {
            Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrix, MiscUtil.localize("crossroads.jei.copshowium.flux"), 10.0f, 10.0f, 0x404040);
        }
        this.arrowStatic.draw(matrix, 75, 56);
        this.arrow.draw(matrix, 75, 56);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CopshowiumRec recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluidGroup = recipeLayout.getFluidStacks();
        fluidGroup.init(0, true, 50, 30, 16, 64, 4000, true, this.fluidOverlay);
        fluidGroup.set(0, recipe.getInput());
        fluidGroup.init(1, false, 110, 30, 16, 64, 4000, true, this.fluidOverlay);
        fluidGroup.set(1, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CopshowiumRec recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.FLUID, (Object)recipe.getInput());
        ingredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)CRFluids.moltenCopshowium.still, (int)((float)recipe.getInput().getAmount() * recipe.getMult())));
    }
}

