/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.recipes.DetailedCrafterRec;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class DetailedCrafterCategory
implements IRecipeCategory<DetailedCrafterRec> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", "detailed_crafter");
    private final IDrawable back;
    private final IDrawable icon;
    private final IDrawable gear;
    private final IDrawable flask;
    private final IDrawable leaf;
    private final ICraftingGridHelper gridHelper;

    protected DetailedCrafterCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("crossroads", "textures/gui/container/detailed_crafter.png");
        this.back = guiHelper.createDrawable(location, 29, 16, 125, 60);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRBlocks.detailedCrafter, 1));
        this.gear = guiHelper.createDrawable(location, 176, 0, 16, 16);
        this.flask = guiHelper.createDrawable(location, 176, 16, 16, 16);
        this.leaf = guiHelper.createDrawable(location, 176, 32, 16, 16);
        this.gridHelper = guiHelper.createCraftingGridHelper(1);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends DetailedCrafterRec> getRecipeClass() {
        return DetailedCrafterRec.class;
    }

    public String getTitle() {
        return CRBlocks.detailedCrafter.func_235333_g_().getString();
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public void setRecipe(IRecipeLayout layout, DetailedCrafterRec recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        int width = recipe.func_192403_f();
        int height = recipe.func_192404_g();
        if (width > 0 && height > 0) {
            this.gridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, width, height);
        } else {
            this.gridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
            layout.setShapeless();
        }
        guiItemStacks.set(0, (List)outputs.get(0));
    }

    public void draw(DetailedCrafterRec recipe, MatrixStack matrix, double mouseX, double mouseY) {
        switch (recipe.getPath()) {
            case TECHNOMANCY: {
                this.gear.draw(matrix, 95, 44);
                break;
            }
            case ALCHEMY: {
                this.flask.draw(matrix, 79, 44);
                break;
            }
            case WITCHCRAFT: {
                this.leaf.draw(matrix, 111, 44);
            }
        }
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(DetailedCrafterRec recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }
}

