/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.integration.JEI.JEICrossroadsPlugin;
import com.Da_Technomancer.crossroads.items.crafting.recipes.FluidCoolingRec;
import com.mojang.blaze3d.matrix.MatrixStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class FluidCoolingCategory
implements IRecipeCategory<FluidCoolingRec> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", "fluid_cooling");
    private final IDrawable back;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic arrowStatic;
    private final IDrawable fluidOverlay;

    protected FluidCoolingCategory(IGuiHelper guiHelper) {
        this.back = guiHelper.createBlankDrawable(180, 100);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRBlocks.fluidCoolingChamber, 1));
        this.slot = guiHelper.getSlotDrawable();
        this.arrowStatic = guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 79, 35, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 176, 14, 24, 17), 40, IDrawableAnimated.StartDirection.LEFT, false);
        this.fluidOverlay = JEICrossroadsPlugin.createFluidOverlay(guiHelper);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends FluidCoolingRec> getRecipeClass() {
        return FluidCoolingRec.class;
    }

    public String getTitle() {
        return CRBlocks.fluidCoolingChamber.func_235333_g_().getString();
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public void draw(FluidCoolingRec rec, MatrixStack matrix, double mouseX, double mouseY) {
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrix, MiscUtil.localize("crossroads.jei.fluid_cooling.max", Float.valueOf(rec.getMaxTemp())), 10.0f, 10.0f, 0x404040);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrix, MiscUtil.localize("crossroads.jei.fluid_cooling.add", Float.valueOf(rec.getAddedHeat())), 10.0f, 20.0f, 0x404040);
        this.slot.draw(matrix, 110, 55);
        this.arrowStatic.draw(matrix, 75, 56);
        this.arrow.draw(matrix, 75, 56);
    }

    public void setRecipe(IRecipeLayout recipeLayout, FluidCoolingRec recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemGroup = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidGroup = recipeLayout.getFluidStacks();
        fluidGroup.init(0, true, 50, 30, 16, 64, 1000, true, this.fluidOverlay);
        fluidGroup.set(0, recipe.getInput());
        itemGroup.init(0, false, 110, 55);
        itemGroup.set(0, recipe.func_77571_b());
        itemGroup.set(ingredients);
        fluidGroup.set(ingredients);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(FluidCoolingRec fluidCoolingRecipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.FLUID, (Object)fluidCoolingRecipe.getInput());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)fluidCoolingRecipe.func_77571_b());
    }
}

