/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.integration.JEI.ReagIngr;
import com.Da_Technomancer.crossroads.integration.JEI.ReagentIngredientRenderer;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ReagInfoCategory
implements IRecipeCategory<IReagent> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", "reag_info");
    private final IDrawable back;
    private final IDrawable icon;

    protected ReagInfoCategory(IGuiHelper guiHelper) {
        this.back = guiHelper.createBlankDrawable(180, 100);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRItems.phialGlass, 1));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends IReagent> getRecipeClass() {
        return IReagent.class;
    }

    public String getTitle() {
        return "Reagent Info";
    }

    public List<ITextComponent> getTooltipStrings(IReagent recipe, double mouseX, double mouseY) {
        if (mouseX >= 2.0 && mouseX <= 18.0 && mouseY >= 2.0 && mouseY <= 18.0) {
            return ImmutableList.of((Object)new StringTextComponent(recipe.getName()));
        }
        return Collections.emptyList();
    }

    public void draw(IReagent recipe, MatrixStack matrix, double mouseX, double mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        double melt = recipe.getMeltingPoint();
        double boil = recipe.getBoilingPoint();
        String line = melt >= 32757.0 ? MiscUtil.localize("crossroads.jei.reagent.melting.no") : (melt <= -273.0 ? MiscUtil.localize("crossroads.jei.reagent.melting.yes") : MiscUtil.localize("crossroads.jei.reagent.melting", Math.round(melt)));
        fontRenderer.func_238421_b_(matrix, line, 2.0f, 22.0f, 0x404040);
        line = boil >= 32757.0 ? MiscUtil.localize("crossroads.jei.reagent.boiling.no") : (boil <= -273.0 ? MiscUtil.localize("crossroads.jei.reagent.boiling.yes") : MiscUtil.localize("crossroads.jei.reagent.boiling", Math.round(boil)));
        fontRenderer.func_238421_b_(matrix, line, 2.0f, 42.0f, 0x404040);
        if (recipe.requiresCrystal()) {
            fontRenderer.func_238421_b_(matrix, MiscUtil.localize("crossroads.jei.reagent.crystal"), 2.0f, 62.0f, 0x404040);
        }
        ReagentIngredientRenderer.RENDERER.render(matrix, 2, 2, new ReagIngr(recipe, 1));
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IReagent recipe, IIngredients ingredients) {
        ReagIngr reagIngr = new ReagIngr(recipe, 1);
        ingredients.setInput(ReagIngr.REAG, (Object)reagIngr);
        ingredients.setOutput(ReagIngr.REAG, (Object)reagIngr);
        List<ItemStack> solid = recipe.getJEISolids();
        ingredients.setInputs(VanillaTypes.ITEM, solid);
        ingredients.setOutputs(VanillaTypes.ITEM, solid);
    }

    public void setRecipe(IRecipeLayout layout, IReagent recipe, IIngredients ingredients) {
        IGuiIngredientGroup reagGroup = layout.getIngredientsGroup(ReagIngr.REAG);
        reagGroup.init(0, true, 2, 2);
        reagGroup.set(0, (List)ingredients.getInputs(ReagIngr.REAG).get(0));
        layout.getIngredientsGroup(VanillaTypes.ITEM).init(0, true, 20, 2);
        layout.getIngredientsGroup(VanillaTypes.ITEM).set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

