/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.recipes.StampMillRec;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class StampMillCategory
implements IRecipeCategory<StampMillRec> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", "stamp_mill");
    private final IDrawable back;
    private final IDrawable slot;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic arrowStatic;
    private final IDrawable icon;

    protected StampMillCategory(IGuiHelper guiHelper) {
        this.back = guiHelper.createBlankDrawable(180, 100);
        this.slot = guiHelper.getSlotDrawable();
        this.arrowStatic = guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 79, 35, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 176, 14, 24, 17), 40, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRBlocks.stampMill, 1));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends StampMillRec> getRecipeClass() {
        return StampMillRec.class;
    }

    public String getTitle() {
        return CRBlocks.stampMill.func_235333_g_().getString();
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(StampMillRec recipe, MatrixStack matrix, double mouseX, double mouseY) {
        this.slot.draw(matrix, 54, 50);
        this.slot.draw(matrix, 110, 50);
        this.arrowStatic.draw(matrix, 78, 50);
        this.arrow.draw(matrix, 78, 50);
    }

    public void setRecipe(IRecipeLayout layout, StampMillRec recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemGroup = layout.getItemStacks();
        itemGroup.init(0, true, 54, 50);
        itemGroup.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemGroup.init(1, false, 110, 50);
        itemGroup.set(1, recipe.func_77571_b());
        itemGroup.set(ingredients);
    }

    public void setIngredients(StampMillRec recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }
}

