/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.SendChatToClient;
import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.templates.IBeamRenderTE;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class OmniMeter
extends Item {
    private static final int CHAT_ID = 279478;

    protected OmniMeter() {
        super(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS).func_200917_a(1));
        String name = "omnimeter";
        this.setRegistryName(name);
        CRItems.toRegister.add(this);
    }

    public static void measure(ArrayList<ITextComponent> chat, PlayerEntity player, World world, BlockPos pos, Direction facing, BlockRayTraceResult hit) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            LazyOptional redsOpt;
            LazyOptional engOpt;
            LazyOptional axisOpt;
            LazyOptional fluidOpt = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (fluidOpt.isPresent()) {
                IFluidHandler pipe = (IFluidHandler)fluidOpt.orElseThrow(NullPointerException::new);
                int tanks = pipe.getTanks();
                if (tanks == 1) {
                    chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.meter.fluid_tank.single"));
                } else {
                    chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.meter.fluid_tank.plural", new Object[]{tanks}));
                }
                for (int tank = 0; tank < tanks; ++tank) {
                    chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.meter.fluid_tank.info", new Object[]{pipe.getTankCapacity(tank), MiscUtil.getLocalizedFluidName(pipe.getFluidInTank(tank).getTranslationKey()), pipe.getFluidInTank(tank).getAmount()}));
                }
            }
            if ((axisOpt = te.getCapability(Capabilities.AXIS_CAPABILITY, null)).isPresent()) {
                chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.meter.axis", new Object[]{CRConfig.formatVal(((IAxisHandler)axisOpt.orElseThrow(NullPointerException::new)).getTotalEnergy())}));
            }
            if ((engOpt = te.getCapability(CapabilityEnergy.ENERGY, null)).isPresent()) {
                IEnergyStorage batt = (IEnergyStorage)engOpt.orElseThrow(NullPointerException::new);
                chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.meter.fe", new Object[]{batt.getEnergyStored(), batt.getMaxEnergyStored()}));
            }
            if ((redsOpt = te.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, null)).isPresent()) {
                IRedstoneHandler redstoneHandler = (IRedstoneHandler)redsOpt.orElseThrow(NullPointerException::new);
                chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.meter.circuit", new Object[]{CRConfig.formatVal(redstoneHandler.getOutput())}));
            }
        }
        if (te instanceof IBeamRenderTE) {
            BeamUnit[] mag = ((IBeamRenderTE)te).getLastSent();
            boolean output = false;
            if (mag != null) {
                for (int i = 0; i < mag.length; ++i) {
                    BeamUnit check = mag[i];
                    if (check.isEmpty()) continue;
                    output = true;
                    EnumBeamAlignments.getAlignment(check).discover(player, true);
                    String dir = Direction.func_82600_a((int)i).toString();
                    dir = Character.toUpperCase(dir.charAt(0)) + dir.substring(1);
                    chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.meter.beam", new Object[]{dir, check.toString()}));
                }
            }
            if (!output) {
                chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.meter.beam.none"));
            }
        }
        if (te instanceof IInfoTE) {
            ((IInfoTE)te).addInfo(chat, player, hit);
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K) {
            ArrayList<ITextComponent> chat = new ArrayList<ITextComponent>();
            BlockRayTraceResult result = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), false);
            OmniMeter.measure(chat, context.func_195999_j(), context.func_195991_k(), context.func_195995_a(), context.func_196000_l(), result);
            if (!chat.isEmpty()) {
                CRPackets.sendPacketToPlayer((ServerPlayerEntity)context.func_195999_j(), new SendChatToClient(chat, 279478));
            }
        }
        return ActionResultType.SUCCESS;
    }
}

