/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.entity.EntityBullet;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.tileentities.rotary.WindingTableTileEntity;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpringGun
extends ShootableItem
implements WindingTableTileEntity.IWindableItem {
    private static final ITag<Item> AMMO_TAG = ItemTags.func_199901_a((String)"crossroads:spring_gun_ammo");
    private static final Predicate<ItemStack> AMMO_PREDICATE = s -> AMMO_TAG.func_230235_a_((Object)s.func_77973_b());
    private static final double MIN_SPEED = 1.0;

    protected SpringGun() {
        super(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS).func_200917_a(1));
        String name = "spring_gun";
        this.setRegistryName(name);
        CRItems.toRegister.add((Item)this);
    }

    private float calcDamage(double wind) {
        return Math.max(Math.round(20.8 * Math.sqrt(wind) - 15.8), 0L);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack held = playerIn.func_184586_b(hand);
        double wind = this.getWindLevel(held);
        ItemStack ammo = playerIn.func_213356_f(held);
        if (wind > 1.0 && !ammo.func_190926_b()) {
            if (!worldIn.field_72995_K) {
                ItemStack bulletItem = ammo.func_77946_l();
                bulletItem.func_190920_e(1);
                EntityBullet bullet = new EntityBullet(worldIn, (LivingEntity)playerIn, this.calcDamage(wind), bulletItem);
                bullet.func_70186_c(playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + 1.2, playerIn.func_226281_cx_(), (float)wind * 2.5f, 0.2f);
                worldIn.func_217376_c((Entity)bullet);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    ammo.func_190918_g(1);
                }
                worldIn.func_184148_a(playerIn, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            playerIn.func_213823_a(SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.setWindLevel(held, 0.0);
            return ActionResult.func_226248_a_((Object)held);
        }
        return ActionResult.func_226251_d_((Object)held);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        double wind = this.getWindLevel(stack);
        double maxWind = this.getMaxWind();
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.spring_speed", new Object[]{CRConfig.formatVal(wind), CRConfig.formatVal(maxWind)}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.spring_gun.winding", new Object[]{CRConfig.formatVal(this.calcDamage(wind)), CRConfig.formatVal(this.calcDamage(maxWind))}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.spring_gun.desc"));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.spring_gun.quip").func_230530_a_(MiscUtil.TT_QUIP));
    }

    @Override
    public double getMaxWind() {
        return (Double)CRConfig.springGunCap.get();
    }

    public Predicate<ItemStack> func_220004_b() {
        return AMMO_PREDICATE;
    }

    public int func_230305_d_() {
        return 15;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.CROSSBOW;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this, 1));
            ItemStack stack = new ItemStack((IItemProvider)this, 1);
            this.setWindLevel(stack, this.getMaxWind());
            items.add((Object)stack);
        }
    }
}

