/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class PredicateMap<T, V> {
    private final HashMap<Predicate<T>, V> entries = new HashMap();
    private final V nullCase;

    public PredicateMap() {
        this.nullCase = null;
    }

    public PredicateMap(V nullCase) {
        this.nullCase = nullCase;
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean containsKey(@Nonnull Predicate<T> key) {
        return this.entries.containsKey(key);
    }

    public V get(T target) {
        for (Map.Entry<Predicate<T>, V> ent : this.entries.entrySet()) {
            if (!ent.getKey().test(target)) continue;
            return ent.getValue();
        }
        return this.nullCase;
    }

    public V put(@Nonnull Predicate<T> key, V value) {
        V removed = this.entries.put(key, value);
        return removed == null ? this.nullCase : removed;
    }

    public V remove(@Nonnull Predicate<T> key) {
        V removed = this.entries.remove(key);
        return removed == null ? this.nullCase : removed;
    }

    public void clear() {
        this.entries.clear();
    }

    public Set<Map.Entry<Predicate<T>, V>> entrySet() {
        return this.entries.entrySet();
    }

    public Collection<V> values() {
        return this.entries.values();
    }
}

