/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.CraftingUtil;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BeamExtractRec
implements IOptionalRecipe<IInventory> {
    private final ResourceLocation id;
    private final String group;
    private final Ingredient ingr;
    private final BeamUnit output;
    private final int duration;
    private final boolean active;

    public BeamExtractRec(ResourceLocation location, String name, Ingredient input, BeamUnit output, int duration, boolean active) {
        this.id = location;
        this.group = name;
        this.ingr = input;
        this.output = output;
        this.duration = duration;
        this.active = active;
    }

    public BeamUnit getOutput() {
        return this.output;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.active && this.ingr.test(inv.func_70301_a(0));
    }

    @Override
    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b();
    }

    @Override
    public boolean isEnabled() {
        return this.active;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean isActive() {
        return this.active;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.ingr);
        return nonnulllist;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)CRBlocks.beamExtractor);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CRRecipes.BEAM_EXTRACT_SERIAL;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeType<?> func_222127_g() {
        return CRRecipes.BEAM_EXTRACT_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BeamExtractRec> {
        public BeamExtractRec read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredient = Ingredient.field_193370_a;
            boolean active = CraftingUtil.isActiveJSON(json);
            if (active) {
                ingredient = CraftingUtil.getIngredient((JsonElement)json, "input", true);
                int[] units = new int[4];
                if (JSONUtils.func_151204_g((JsonObject)json, (String)"energy")) {
                    units[0] = JSONUtils.func_151203_m((JsonObject)json, (String)"energy");
                }
                if (JSONUtils.func_151204_g((JsonObject)json, (String)"potential")) {
                    units[1] = JSONUtils.func_151203_m((JsonObject)json, (String)"potential");
                }
                if (JSONUtils.func_151204_g((JsonObject)json, (String)"stability")) {
                    units[2] = JSONUtils.func_151203_m((JsonObject)json, (String)"stability");
                }
                if (JSONUtils.func_151204_g((JsonObject)json, (String)"void")) {
                    units[3] = JSONUtils.func_151203_m((JsonObject)json, (String)"void");
                }
                int dur = JSONUtils.func_151208_a((JsonObject)json, (String)"duration", (int)1);
                return new BeamExtractRec(recipeId, s, ingredient, new BeamUnit(units), dur, true);
            }
            return new BeamExtractRec(recipeId, s, ingredient, BeamUnit.EMPTY, 0, false);
        }

        @Nullable
        public BeamExtractRec read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            boolean active = buffer.readBoolean();
            if (active) {
                Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
                int duration = buffer.func_150792_a();
                int[] units = new int[4];
                for (int i = 0; i < 4; ++i) {
                    units[i] = buffer.func_150792_a();
                }
                return new BeamExtractRec(recipeId, s, ingredient, new BeamUnit(units), duration, true);
            }
            return new BeamExtractRec(recipeId, s, Ingredient.field_193370_a, BeamUnit.EMPTY, 0, false);
        }

        public void write(PacketBuffer buffer, BeamExtractRec recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.writeBoolean(recipe.active);
            recipe.ingr.func_199564_a(buffer);
            buffer.func_150787_b(recipe.duration);
            buffer.func_150787_b(recipe.output.getEnergy());
            buffer.func_150787_b(recipe.output.getPotential());
            buffer.func_150787_b(recipe.output.getStability());
            buffer.func_150787_b(recipe.output.getVoid());
        }
    }
}

