/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.CraftingUtil;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BlastFurnaceRec
implements IOptionalRecipe<IInventory> {
    private final ResourceLocation id;
    private final String group;
    private final Ingredient ingr;
    private final FluidStack output;
    private final int slag;
    private final boolean active;

    public BlastFurnaceRec(ResourceLocation location, String name, Ingredient input, FluidStack output, int slag, boolean active) {
        this.id = location;
        this.group = name;
        this.ingr = input;
        this.output = output;
        this.slag = slag;
        this.active = active;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public int getSlag() {
        return this.slag;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.isEnabled() && this.ingr.test(inv.func_70301_a(0));
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.ingr);
        return nonnulllist;
    }

    @Override
    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b().func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.active;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)CRItems.slag, this.slag);
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)CRBlocks.blastFurnace);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CRRecipes.BLAST_FURNACE_SERIAL;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeType<?> func_222127_g() {
        return CRRecipes.BLAST_FURNACE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BlastFurnaceRec> {
        public BlastFurnaceRec read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            if (!CraftingUtil.isActiveJSON(json)) {
                return new BlastFurnaceRec(recipeId, s, Ingredient.field_193370_a, FluidStack.EMPTY, 0, false);
            }
            Ingredient ingredient = CraftingUtil.getIngredient((JsonElement)json, "ingredient", false);
            FluidStack fluid = CraftingUtil.getFluidStack(json, "output");
            int slag = JSONUtils.func_151208_a((JsonObject)json, (String)"slag", (int)0);
            return new BlastFurnaceRec(recipeId, s, ingredient, fluid, slag, true);
        }

        @Nullable
        public BlastFurnaceRec read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            if (buffer.readBoolean()) {
                Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
                FluidStack fluid = FluidStack.readFromPacket((PacketBuffer)buffer);
                int slag = buffer.func_150792_a();
                return new BlastFurnaceRec(recipeId, s, ingredient, fluid, slag, true);
            }
            return new BlastFurnaceRec(recipeId, s, Ingredient.field_193370_a, FluidStack.EMPTY, 0, false);
        }

        public void write(PacketBuffer buffer, BlastFurnaceRec recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.writeBoolean(recipe.active);
            recipe.ingr.func_199564_a(buffer);
            recipe.output.writeToPacket(buffer);
            buffer.func_150787_b(recipe.slag);
        }
    }
}

