/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.Crossroads;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockIngredient
implements Predicate<BlockState> {
    public static final BlockIngredient EMPTY = new BlockIngredient(new Object[0]);
    private final List<IBlockList> keys;
    private boolean cacheValid = false;
    private final Collection<Block> matched = new HashSet<Block>();

    public BlockIngredient(Object ... matched) {
        if (matched.length == 1 && matched[0].getClass().isArray()) {
            matched = (Object[])matched[0];
        }
        this.keys = new ArrayList<IBlockList>(matched.length);
        for (Object key : matched) {
            if (key instanceof IBlockList) {
                this.keys.add((IBlockList)key);
                continue;
            }
            if (key instanceof ITag) {
                try {
                    ITag tag = (ITag)key;
                    this.keys.add(new TagList((ITag<Block>)tag));
                    continue;
                }
                catch (ClassCastException e) {
                    Crossroads.logger.error("An illegal tag type was added to a BlockIngredient. Report to mod author!", (Throwable)e);
                    throw e;
                }
            }
            if (key instanceof Block) {
                this.keys.add(new SingleList((Block)key));
                continue;
            }
            if (key instanceof BlockState) {
                this.keys.add(new SingleList(((BlockState)key).func_177230_c()));
                continue;
            }
            JsonParseException e = new JsonParseException("Illegal type added to BlockIngredient; Type: " + key.getClass() + "; Value: " + key.toString());
            Crossroads.logger.error("An illegal value was added to a BlockIngredient. Report to mod author!", (Throwable)e);
            throw e;
        }
    }

    @Deprecated
    public List<ItemStack> getMatchedItemForm() {
        this.updateCache();
        return ((Stream)this.matched.parallelStream().unordered()).map(ItemStack::new).distinct().filter(s -> s.func_77973_b() != Items.field_190931_a).collect(Collectors.toList());
    }

    private void updateCache() {
        if (!this.cacheValid) {
            this.matched.clear();
            this.keys.forEach(key -> this.matched.addAll(key.getMatched()));
            this.cacheValid = true;
        }
    }

    public void writeToBuffer(PacketBuffer buf) {
        this.updateCache();
        buf.func_150787_b(this.matched.size());
        for (Block b : this.matched) {
            buf.func_192572_a(b.getRegistryName());
        }
    }

    public static BlockIngredient readFromBuffer(PacketBuffer buf) {
        int count = buf.func_150792_a();
        Block[] matched = new Block[count];
        for (int i = 0; i < count; ++i) {
            matched[i] = (Block)ForgeRegistries.BLOCKS.getValue(buf.func_192575_l());
        }
        return new BlockIngredient(new BlockList(matched));
    }

    public static BlockIngredient readFromJSON(JsonElement o) {
        if (o.isJsonArray()) {
            JsonArray array = (JsonArray)o;
            IBlockList[] lists = new IBlockList[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                JsonElement el = array.get(i);
                if (!el.isJsonObject()) {
                    throw new JsonParseException("Value in JSON array instead of JSON object");
                }
                lists[i] = BlockIngredient.readIngr((JsonObject)el);
            }
            return new BlockIngredient(lists);
        }
        if (o.isJsonObject()) {
            return new BlockIngredient(BlockIngredient.readIngr((JsonObject)o));
        }
        throw new JsonParseException("Value passed to BlockIngredient");
    }

    private static IBlockList readIngr(JsonObject o) {
        if (o.has("tag")) {
            return new TagList((ITag<Block>)BlockTags.func_199894_a((String)JSONUtils.func_151200_h((JsonObject)o, (String)"tag")));
        }
        if (o.has("block")) {
            return new SingleList((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)o, (String)"block"))));
        }
        throw new JsonParseException("No value defined in BlockIngredient");
    }

    @Override
    public boolean test(BlockState blockState) {
        this.updateCache();
        Block b = blockState.func_177230_c();
        return this.matched.contains(b);
    }

    private static class BlockList
    implements IBlockList {
        private final Collection<Block> blocks;

        public BlockList(Block ... matched) {
            this.blocks = Arrays.asList(matched);
        }

        @Override
        public Collection<Block> getMatched() {
            return this.blocks;
        }
    }

    private static class TagList
    implements IBlockList {
        private final ITag<Block> tag;

        public TagList(ITag<Block> matched) {
            this.tag = matched;
        }

        @Override
        public Collection<Block> getMatched() {
            return this.tag.func_230236_b_();
        }
    }

    private static class SingleList
    implements IBlockList {
        private final List<Block> matchL = new ArrayList<Block>(1);

        public SingleList(Block matched) {
            this.matchL.add(matched);
            if (matched == null) {
                throw new JsonParseException("No defined block in BlockIngredient");
            }
        }

        @Override
        public Collection<Block> getMatched() {
            return this.matchL;
        }
    }

    private static interface IBlockList {
        public Collection<Block> getMatched();
    }
}

