/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.items.crafting.CraftingUtil;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class SingleIngrRecipe
implements IOptionalRecipe<IInventory> {
    protected final Ingredient ingredient;
    protected final ItemStack result;
    private final IRecipeType<?> type;
    private final IRecipeSerializer<?> serializer;
    protected final ResourceLocation id;
    protected final String group;
    protected final boolean active;

    public SingleIngrRecipe(IRecipeType<?> type, IRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient ingredient, ItemStack result, boolean active) {
        this.type = type;
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.result = result;
        this.active = active;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this.serializer;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.active;
    }

    public String func_193358_e() {
        return this.group;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.isEnabled() && this.ingredient.test(inv.func_70301_a(0));
    }

    public boolean func_194133_a(int width, int height) {
        return width != 0 && height != 0;
    }

    public static class SingleRecipeSerializer<T extends SingleIngrRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IRecipeFactory<T> factory;

        public SingleRecipeSerializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            if (!CraftingUtil.isActiveJSON(json)) {
                return this.factory.create(recipeId, s, Ingredient.field_193370_a, ItemStack.field_190927_a, false);
            }
            Ingredient ingredient = CraftingUtil.getIngredient((JsonElement)json, "ingredient", false);
            ItemStack itemstack = CraftingUtil.getItemStack(json, "output", true, true);
            return this.factory.create(recipeId, s, ingredient, itemstack, true);
        }

        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            if (!buffer.readBoolean()) {
                return this.factory.create(recipeId, s, Ingredient.field_193370_a, ItemStack.field_190927_a, false);
            }
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack itemstack = buffer.func_150791_c();
            return this.factory.create(recipeId, s, ingredient, itemstack, true);
        }

        public void write(PacketBuffer buffer, T recipe) {
            buffer.func_180714_a(((SingleIngrRecipe)recipe).func_193358_e());
            buffer.writeBoolean(((SingleIngrRecipe)recipe).isEnabled());
            ((Ingredient)((SingleIngrRecipe)recipe).func_192400_c().get(0)).func_199564_a(buffer);
            buffer.func_150788_a(((SingleIngrRecipe)recipe).func_77571_b());
        }

        public static interface IRecipeFactory<T extends SingleIngrRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, boolean var5);
        }
    }
}

