/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.itemSets;

import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.Crossroads;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.itemSets.GearFactory;
import com.Da_Technomancer.crossroads.items.itemSets.GearMatItem;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.IMechanism;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.MechanismTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BasicGear
extends GearMatItem {
    public BasicGear() {
        this("gear_base");
    }

    protected BasicGear(String name) {
        this.setRegistryName(name);
    }

    @Override
    protected double shapeFactor() {
        return 0.015625;
    }

    protected IMechanism mechanismToPlace() {
        return MechanismTileEntity.MECHANISMS.get(0);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        GearFactory.GearMaterial type = BasicGear.getMaterial(context.func_195996_i());
        if (type == null) {
            return ActionResultType.SUCCESS;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        BlockPos placePos = pos.func_177972_a(side);
        PlayerEntity playerIn = context.func_195999_j();
        BlockState stateAtPlacement = world.func_180495_p(placePos);
        TileEntity teAtPlacement = world.func_175625_s(placePos);
        if (RotaryUtil.solidToGears(world, pos, side)) {
            int mechInd = side.func_176734_d().func_176745_a();
            if (teAtPlacement instanceof MechanismTileEntity) {
                MechanismTileEntity mte = (MechanismTileEntity)teAtPlacement;
                if (mte.members[mechInd] != null) {
                    return ActionResultType.SUCCESS;
                }
                mte.setMechanism(mechInd, this.mechanismToPlace(), type, null, false);
                if (!(world.field_72995_K || playerIn != null && playerIn.func_184812_l_())) {
                    context.func_195996_i().func_190918_g(1);
                }
                RotaryUtil.increaseMasterKey(!world.field_72995_K);
            } else if (stateAtPlacement.func_196953_a(new BlockItemUseContext(context))) {
                world.func_180501_a(placePos, CRBlocks.mechanism.func_176223_P(), 3);
                teAtPlacement = world.func_175625_s(placePos);
                if (teAtPlacement instanceof MechanismTileEntity) {
                    ((MechanismTileEntity)teAtPlacement).setMechanism(mechInd, this.mechanismToPlace(), type, null, true);
                } else {
                    Crossroads.logger.error("Mechanism TileEntity did not exist at gear placement; Report to mod author");
                }
                if (!(world.field_72995_K || playerIn != null && playerIn.func_184812_l_())) {
                    context.func_195996_i().func_190918_g(1);
                }
                RotaryUtil.increaseMasterKey(!world.field_72995_K);
            }
        }
        return ActionResultType.SUCCESS;
    }
}

