/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.itemSets;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.Crossroads;
import com.Da_Technomancer.crossroads.blocks.BasicBlock;
import com.Da_Technomancer.crossroads.items.CRItems;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public final class OreSetup {
    public static Item ingotTin;
    public static Item nuggetTin;
    public static BasicBlock blockTin;
    public static BasicBlock oreTin;
    public static Item ingotCopper;
    public static Item nuggetCopper;
    public static BasicBlock blockCopper;
    public static BasicBlock oreCopper;
    public static Item ingotBronze;
    public static Item nuggetBronze;
    public static BasicBlock blockBronze;
    public static Item gemRuby;
    public static BasicBlock blockRuby;
    public static BasicBlock oreRuby;
    public static Item ingotCopshowium;
    public static Item nuggetCopshowium;
    public static BasicBlock blockCopshowium;
    public static Item voidCrystal;
    public static BasicBlock oreVoid;
    private static final HashMap<String, OreProfile> metalTypes;
    private static OreProfile DEFAULT;

    public static OreProfile findMaterial(String id) {
        return metalTypes.getOrDefault(id, OreSetup.getDefaultMaterial());
    }

    public static Collection<OreProfile> getMaterials() {
        return metalTypes.values();
    }

    public static void registerMaterial(OreProfile mat) {
        metalTypes.put(mat.getId(), mat);
    }

    public static OreProfile getDefaultMaterial() {
        return DEFAULT;
    }

    protected static void init() {
        ingotTin = (Item)new Item(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS)).setRegistryName("ingot_tin");
        CRItems.toRegister.add(ingotTin);
        blockTin = new BasicBlock("block_tin", AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(5.0f));
        nuggetTin = (Item)new Item(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS)).setRegistryName("nugget_tin");
        CRItems.toRegister.add(nuggetTin);
        oreTin = new BasicBlock("ore_tin", AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.0f));
        ingotCopper = (Item)new Item(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS)).setRegistryName("ingot_copper");
        CRItems.toRegister.add(ingotCopper);
        blockCopper = new BasicBlock("block_copper", AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(5.0f));
        nuggetCopper = (Item)new Item(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS)).setRegistryName("nugget_copper");
        CRItems.toRegister.add(nuggetCopper);
        oreCopper = new BasicBlock("ore_copper", AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.0f));
        ingotBronze = (Item)new Item(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS)).setRegistryName("ingot_bronze");
        CRItems.toRegister.add(ingotBronze);
        blockBronze = new BasicBlock("block_bronze", AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(5.0f));
        nuggetBronze = (Item)new Item(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS)).setRegistryName("nugget_bronze");
        CRItems.toRegister.add(nuggetBronze);
        gemRuby = (Item)new Item(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS)).setRegistryName("gem_ruby");
        CRItems.toRegister.add(gemRuby);
        blockRuby = new BasicBlock("block_ruby", AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(5.0f));
        oreRuby = new BasicBlock("ore_ruby", AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.0f).harvestLevel(2));
        ingotCopshowium = (Item)new Item(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS)){

            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.copshowium.quip").func_230530_a_(MiscUtil.TT_QUIP));
            }
        }.setRegistryName("ingot_copshowium");
        CRItems.toRegister.add(ingotCopshowium);
        blockCopshowium = new BasicBlock("block_copshowium", AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(5.0f));
        nuggetCopshowium = (Item)new Item(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS)).setRegistryName("nugget_copshowium");
        CRItems.toRegister.add(nuggetCopshowium);
        voidCrystal = (Item)new Item(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS)).setRegistryName("void_crystal");
        CRItems.toRegister.add(voidCrystal);
        oreVoid = new BasicBlock("ore_void", AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 9.0f).harvestLevel(2));
        OreSetup.loadConfig();
    }

    public static void loadConfig() {
        ArrayList<String> toRemove = new ArrayList<String>(metalTypes.size());
        for (OreProfile oreProfile : metalTypes.values()) {
            if (!oreProfile.wipeOnReload()) continue;
            toRemove.add(oreProfile.id);
        }
        toRemove.forEach(metalTypes::remove);
        List rawInput = (List)CRConfig.processableOres.get();
        for (String raw : rawInput) {
            Color col;
            int spaceIndex = raw.length() - 7;
            String metal = raw.substring(0, spaceIndex);
            String colorString = '#' + raw.substring(spaceIndex + 1);
            try {
                col = Color.decode(colorString);
            }
            catch (NumberFormatException e) {
                col = Color.getHSBColor((float)Math.random(), 1.0f, 1.0f);
                Crossroads.logger.error(String.format("Invalid color defined for ore profile: %s; Selecting random color", metal), (Throwable)e);
            }
            OreSetup.registerMaterial(new OreProfile(metal, col));
        }
        DEFAULT = metalTypes.get("iron");
        if (DEFAULT == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Default Ore Profile not registered!");
            Crossroads.logger.error("Config Modified to prevent registering default ore profile (iron)", (Throwable)illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    static {
        metalTypes = new HashMap();
    }

    public static class OreProfile {
        private final String id;
        private final Color color;
        private final boolean shouldReload;

        protected OreProfile(String nameIn, Color matColor) {
            this(nameIn, matColor, true);
        }

        protected OreProfile(String nameIn, Color matColor, boolean shouldReload) {
            this.id = nameIn;
            this.color = matColor;
            this.shouldReload = shouldReload;
        }

        public boolean wipeOnReload() {
            return this.shouldReload;
        }

        public String getId() {
            return this.id;
        }

        public Color getColor() {
            return this.color;
        }

        public String getName() {
            return MiscUtil.localize("material." + this.id);
        }
    }
}

