/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.technomancy;

import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.SendBeamItemToServer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class BeamUsingItem
extends Item {
    private static final String NBT_KEY = "setting";
    private static long lastKeyTime = 0L;

    protected BeamUsingItem(Item.Properties properties) {
        super(properties);
    }

    protected abstract byte maxSetting();

    public static byte[] getSetting(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            return new byte[4];
        }
        return nbt.func_74770_j(NBT_KEY);
    }

    public static void setSetting(ItemStack stack, byte[] settings) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74773_a(NBT_KEY, settings);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void adjustSetting(ClientPlayerEntity player, ItemStack stack, int elemIndex, boolean increase) {
        long currTime = System.currentTimeMillis();
        long timeSince = currTime - lastKeyTime;
        if (timeSince < 0L) {
            timeSince = 1000000L;
        }
        if (timeSince < 250L) {
            return;
        }
        lastKeyTime = currTime;
        byte[] settings = BeamUsingItem.getSetting(stack);
        boolean acted = false;
        if (increase) {
            if (settings[elemIndex] < this.maxSetting()) {
                int n = elemIndex;
                settings[n] = (byte)(settings[n] + 1);
                acted = true;
            }
        } else if (settings[elemIndex] > 0) {
            int n = elemIndex;
            settings[n] = (byte)(settings[n] - 1);
            acted = true;
        }
        if (acted) {
            player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 4.0f, (float)Math.random() / 4.0f + 0.5f);
            CRPackets.sendPacketToServer(new SendBeamItemToServer(settings));
        } else {
            player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 4.0f, (float)Math.random() / 4.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        byte[] settings = BeamUsingItem.getSetting(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.beam_item.energy", new Object[]{settings[0], this.maxSetting()}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.beam_item.potential", new Object[]{settings[1], this.maxSetting()}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.beam_item.stability", new Object[]{settings[2], this.maxSetting()}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.beam_item.void", new Object[]{settings[3], this.maxSetting()}));
    }
}

