/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.technomancy;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.SendChatToClient;
import com.Da_Technomancer.crossroads.API.technomancy.EnumGoggleLenses;
import com.Da_Technomancer.crossroads.items.CRItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ModuleGoggles
extends ArmorItem {
    private static final IArmorMaterial TECHNOMANCY_MAT = new TechnoMat();
    private static final int CHAT_ID = 718749;

    public ModuleGoggles() {
        super(TECHNOMANCY_MAT, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS).func_200917_a(1));
        String name = "module_goggles";
        this.setRegistryName(name);
        CRItems.toRegister.add((Item)this);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        CompoundNBT nbt;
        if (!world.field_72995_K && (nbt = stack.func_77978_p()) != null) {
            ArrayList<ITextComponent> chat = new ArrayList<ITextComponent>();
            BlockRayTraceResult ray = MiscUtil.rayTrace((Entity)player, 8.0);
            for (EnumGoggleLenses lens : EnumGoggleLenses.values()) {
                if (!nbt.func_74764_b(lens.toString()) || lens.useKey() && !nbt.func_74767_n(lens.toString())) continue;
                lens.doEffect(world, player, chat, ray);
            }
            if (!chat.isEmpty()) {
                CRPackets.sendPacketToPlayer((ServerPlayerEntity)player, new SendChatToClient(chat, 718749));
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.goggles.lenses"));
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && !nbt.isEmpty()) {
            String enabled = MiscUtil.localize("tt.crossroads.goggles.enabled");
            String disabled = MiscUtil.localize("tt.crossroads.goggles.disabled");
            for (EnumGoggleLenses lens : EnumGoggleLenses.values()) {
                if (!nbt.func_74764_b(lens.toString())) continue;
                tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.goggles." + lens.toString(), new Object[]{nbt.func_74767_n(lens.toString()) ? enabled : disabled}));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.goggles.none"));
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        StringBuilder path = new StringBuilder("crossroads:textures/models/armor/goggles/goggle");
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            for (EnumGoggleLenses lens : EnumGoggleLenses.values()) {
                if (!nbt.func_74764_b(lens.toString())) continue;
                path.append(lens.getTexturePath());
            }
        }
        path.append(".png");
        return path.toString();
    }

    private static class TechnoMat
    implements IArmorMaterial {
        private TechnoMat() {
        }

        public int func_200896_a(EquipmentSlotType slotIn) {
            return 0;
        }

        public int func_200902_b(EquipmentSlotType slotIn) {
            return 0;
        }

        public int func_200900_a() {
            return 0;
        }

        public SoundEvent func_200899_b() {
            return SoundEvents.field_187725_r;
        }

        public Ingredient func_200898_c() {
            return Ingredient.field_193370_a;
        }

        public String func_200897_d() {
            return "technomancy";
        }

        public float func_200901_e() {
            return 0.0f;
        }

        public float func_230304_f_() {
            return 0.0f;
        }
    }
}

