/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.technomancy;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.tileentities.rotary.WindingTableTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RecallDevice
extends Item
implements WindingTableTileEntity.IWindableItem {
    private static final double WIND_USE = 0.4;

    public RecallDevice() {
        super(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS).func_200917_a(1));
        String name = "recall_device";
        this.setRegistryName(name);
        CRItems.toRegister.add(this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.spring_speed", new Object[]{CRConfig.formatVal(this.getWindLevel(stack)), CRConfig.formatVal(this.getMaxWind())}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.recall_device.desc"));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.recall_device.debuff"));
        if ((Integer)CRConfig.recallTimeLimit.get() == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.recall_device.config.disabled"));
        } else {
            long timeElapsed;
            int limit = (Integer)CRConfig.recallTimeLimit.get();
            if (limit < 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.recall_device.config.unlimited"));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.recall_device.config", new Object[]{limit}));
            }
            CompoundNBT nbt = stack.func_190925_c("recall_data");
            if (nbt.func_74764_b("timestamp") && (timeElapsed = worldIn.func_82737_E() - nbt.func_74763_f("timestamp")) < (long)(limit * 20)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.recall_device.current", new Object[]{(int)(timeElapsed / 20L)}));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.recall_device.current.none"));
            }
        }
    }

    private static void storeData(CompoundNBT data, PlayerEntity player) {
        data.func_74772_a("timestamp", player.field_70170_p.func_82737_E());
        String playerName = player.func_146103_bH().getName();
        data.func_74778_a("username", playerName == null ? "NULL" : playerName);
        data.func_74778_a("dimension", player.field_70170_p.func_234923_W_().func_240901_a_().toString());
        data.func_74780_a("pos_x", player.func_226277_ct_());
        data.func_74780_a("pos_y", player.func_226278_cu_());
        data.func_74780_a("pos_z", player.func_226281_cx_());
        data.func_74772_a("position", player.func_233580_cy_().func_218275_a());
        data.func_74776_a("yaw", player.func_195046_g(1.0f));
        data.func_74776_a("yaw_head", player.func_70079_am());
        data.func_74776_a("pitch", player.func_195050_f(1.0f));
        data.func_74776_a("health", player.func_110143_aJ());
        data.func_74768_a("hunger", player.func_71024_bL().func_75116_a());
        data.func_74776_a("saturation", player.func_71024_bL().func_75115_e());
        data.func_74780_a("vel_x", player.func_213322_ci().func_82615_a());
        data.func_74780_a("vel_y", player.func_213322_ci().func_82617_b());
        data.func_74780_a("vel_z", player.func_213322_ci().func_82616_c());
        if (player.field_70170_p.func_201670_d()) {
            player.func_184185_a(SoundEvents.field_219603_Y, 2.0f, 1.0f);
        }
    }

    private void recall(CompoundNBT data, PlayerEntity player, ItemStack held) {
        if (!data.func_74764_b("timestamp")) {
            MiscUtil.chatMessage((Entity)player, (ITextComponent)new TranslationTextComponent("tt.crossroads.recall_device.none"));
            return;
        }
        long delay = player.field_70170_p.func_82737_E() - data.func_74763_f("timestamp");
        int limit = (Integer)CRConfig.recallTimeLimit.get() * 20;
        if (limit >= 0 && delay > (long)limit) {
            MiscUtil.chatMessage((Entity)player, (ITextComponent)new TranslationTextComponent("tt.crossroads.recall_device.expired"));
            return;
        }
        double wind = this.getWindLevel(held);
        if (wind < 0.4) {
            MiscUtil.chatMessage((Entity)player, (ITextComponent)new TranslationTextComponent("tt.crossroads.recall_device.not_wound"));
            return;
        }
        this.setWindLevel(held, wind - 0.4);
        String playerName = player.func_146103_bH().getName();
        if (playerName == null || !playerName.equals(data.func_74779_i("username"))) {
            MiscUtil.chatMessage((Entity)player, (ITextComponent)new TranslationTextComponent("tt.crossroads.recall_device.wrong_player"));
            return;
        }
        if (((Boolean)CRConfig.allowStatRecall.get()).booleanValue()) {
            player.func_70606_j(data.func_74760_g("health"));
            MiscUtil.setPlayerFood(player, data.func_74762_e("hunger"), data.func_74760_g("saturation"));
        }
        if (!player.field_70170_p.field_72995_K) {
            ServerWorld targetWorld;
            ServerPlayerEntity playerServ = (ServerPlayerEntity)player;
            ResourceLocation targetDimension = new ResourceLocation(data.func_74779_i("dimension"));
            if (targetDimension.equals((Object)player.field_70170_p.func_234923_W_().func_240901_a_())) {
                targetWorld = (ServerWorld)player.field_70170_p;
            } else {
                try {
                    targetWorld = MiscUtil.getWorld(MiscUtil.getWorldKey(targetDimension, null), playerServ.field_71133_b);
                }
                catch (Exception e) {
                    targetWorld = null;
                }
            }
            if (targetWorld == player.field_70170_p) {
                playerServ.field_71135_a.func_147364_a(data.func_74769_h("pos_x"), data.func_74769_h("pos_y"), data.func_74769_h("pos_z"), data.func_74760_g("yaw"), data.func_74760_g("pitch"));
            } else if (targetWorld != null) {
                playerServ.func_200619_a(targetWorld, data.func_74769_h("pos_x"), data.func_74769_h("pos_y"), data.func_74769_h("pos_z"), data.func_74760_g("yaw"), data.func_74760_g("pitch"));
            }
        }
        player.func_70034_d(data.func_74760_g("yaw_head"));
        player.func_213317_d(new Vector3d(data.func_74769_h("vel_x"), data.func_74769_h("vel_y"), data.func_74769_h("vel_z")));
        RecallDevice.applySickness(player, delay, limit);
    }

    private static void applySickness(PlayerEntity player, long delay, long delayLimit) {
        int poisonStTime = 600;
        player.func_195064_c(new EffectInstance(Effects.field_76431_k, (int)MathHelper.func_151238_b((double)100.0, (double)600.0, (double)((float)delay / (float)poisonStTime)), 0));
        if (delay > (long)poisonStTime) {
            int poisonDuration = delayLimit < 0L ? 200 : (int)MathHelper.func_151238_b((double)100.0, (double)600.0, (double)((float)(delay - (long)poisonStTime) / (float)(delayLimit - (long)poisonStTime)));
            player.func_195064_c(new EffectInstance(Effects.field_76436_u, poisonDuration, 0));
        }
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_219604_Z, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack held = playerIn.func_184586_b(hand);
        CompoundNBT nbt = held.func_190925_c("recall_data");
        CompoundNBT newStored = new CompoundNBT();
        RecallDevice.storeData(newStored, playerIn);
        if (!playerIn.func_225608_bj_()) {
            worldIn.func_184133_a(null, playerIn.func_233580_cy_(), SoundEvents.field_219604_Z, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.recall(nbt, playerIn, held);
        }
        held.func_77978_p().func_218657_a("recall_data", (INBT)newStored);
        return ActionResult.func_226248_a_((Object)held);
    }

    @Override
    public double getMaxWind() {
        return 10.0;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this, 1));
            ItemStack stack = new ItemStack((IItemProvider)this, 1);
            this.setWindLevel(stack, this.getMaxWind());
            items.add((Object)stack);
        }
    }
}

