/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.particles;

import com.Da_Technomancer.crossroads.particles.CRParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class ColorParticleData
implements IParticleData {
    protected static final Codec<ColorParticleData> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BYTE.fieldOf("type").forGetter(ColorParticleData::getTypeID), (App)Codec.BYTE.fieldOf("r").forGetter(data -> (byte)data.getColor().getRed()), (App)Codec.BYTE.fieldOf("g").forGetter(data -> (byte)data.getColor().getGreen()), (App)Codec.BYTE.fieldOf("b").forGetter(data -> (byte)data.getColor().getGreen()), (App)Codec.BYTE.fieldOf("a").forGetter(data -> (byte)data.getColor().getAlpha())).apply((Applicative)instance, ColorParticleData::new));
    protected static final Deserializer DESERIALIZER = new Deserializer();
    private final ParticleType<ColorParticleData> type;
    private final Color col;

    private ColorParticleData(byte typeID, byte r, byte g, byte b, byte a) {
        this(ColorParticleData.getTypeFromID(typeID), new Color(r, g, b, a));
    }

    public ColorParticleData(ParticleType<ColorParticleData> type, Color col) {
        this.type = type;
        this.col = col;
    }

    public Color getColor() {
        return this.col;
    }

    public ParticleType<?> func_197554_b() {
        return this.type;
    }

    private byte getTypeID() {
        if (this.type == CRParticles.COLOR_GAS) {
            return 0;
        }
        if (this.type == CRParticles.COLOR_LIQUID) {
            return 1;
        }
        if (this.type == CRParticles.COLOR_SOLID) {
            return 2;
        }
        if (this.type == CRParticles.COLOR_FLAME) {
            return 3;
        }
        return 4;
    }

    private static ParticleType<ColorParticleData> getTypeFromID(byte id) {
        switch (id) {
            case 0: {
                return CRParticles.COLOR_GAS;
            }
            case 1: {
                return CRParticles.COLOR_LIQUID;
            }
            case 2: {
                return CRParticles.COLOR_SOLID;
            }
            case 3: {
                return CRParticles.COLOR_FLAME;
            }
        }
        return CRParticles.COLOR_SPLASH;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeInt(this.col.getRGB());
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %d %d %d %d", this.type.getRegistryName(), this.col.getRed(), this.col.getGreen(), this.col.getBlue(), this.col.getAlpha());
    }

    private static class Deserializer
    implements IParticleData.IDeserializer<ColorParticleData> {
        private Deserializer() {
        }

        public ColorParticleData deserialize(ParticleType<ColorParticleData> type, StringReader reader) throws CommandSyntaxException {
            int[] col = new int[4];
            for (int i = 0; i < 4; ++i) {
                reader.expect(' ');
                col[i] = reader.readInt();
            }
            return new ColorParticleData(type, new Color(col[0], col[1], col[2], col[3]));
        }

        public ColorParticleData read(ParticleType<ColorParticleData> type, PacketBuffer buffer) {
            return new ColorParticleData(type, new Color(buffer.readInt(), true));
        }
    }
}

