/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render;

import com.Da_Technomancer.crossroads.render.CRRenderTypes;
import com.Da_Technomancer.crossroads.render.IVisualEffect;
import com.Da_Technomancer.crossroads.render.TESR.BeamRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3f;

public class LooseBeamRenderable
implements IVisualEffect {
    public final double x;
    public final double y;
    public final double z;
    public final double length;
    public final float angleX;
    public final float angleY;
    public final byte width;
    public final int color;
    public byte lifeTime = (byte)6;
    public long lastTick = 0L;

    private LooseBeamRenderable(double x, double y, double z, double length, float angleX, float angleY, byte width, int color) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.length = length;
        this.angleX = angleX;
        this.angleY = angleY;
        this.width = width;
        this.color = color;
    }

    public static LooseBeamRenderable readFromNBT(CompoundNBT nbt) {
        return new LooseBeamRenderable(nbt.func_74760_g("x"), nbt.func_74760_g("y"), nbt.func_74760_g("z"), nbt.func_74769_h("length"), nbt.func_74760_g("angle_x"), nbt.func_74760_g("angle_y"), nbt.func_74771_c("width"), nbt.func_74762_e("color"));
    }

    @Override
    public boolean render(MatrixStack matrix, IRenderTypeBuffer buffer, long worldTime, float partialTicks, Random rand) {
        matrix.func_227861_a_(this.x, this.y, this.z);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-this.angleY));
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(this.angleX + 90.0f));
        BeamRenderer.drawBeam(matrix, buffer.getBuffer(CRRenderTypes.BEAM_TYPE), (float)this.length, (float)this.width / 8.0f, new Color(this.color));
        if (this.lastTick != worldTime) {
            this.lastTick = worldTime;
            byte by = this.lifeTime;
            this.lifeTime = (byte)(by - 1);
            return by < 0;
        }
        return false;
    }
}

