/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render.TESR;

import com.Da_Technomancer.crossroads.API.beams.BeamManager;
import com.Da_Technomancer.crossroads.API.templates.IBeamRenderTE;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.render.CRRenderTypes;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.commons.lang3.tuple.Triple;

public class BeamRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    public BeamRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public static void drawBeam(MatrixStack matrix, IVertexBuilder builder, float length, float width, Color color) {
        float BEAM_SIDE_U = 0.0f;
        float BEAM_END_U = 0.5f;
        float BEAM_V_STOP = 0.5f;
        float halfWidth = width / 2.0f;
        int[] col = new int[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()};
        float endV = length / 2.0f;
        Matrix4f lastMatrix = matrix.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(lastMatrix, -halfWidth, 0.0f, -halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(lastMatrix, -halfWidth, length, -halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.0f, endV).func_181675_d();
        builder.func_227888_a_(lastMatrix, -halfWidth, length, halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.5f, endV).func_181675_d();
        builder.func_227888_a_(lastMatrix, -halfWidth, 0.0f, halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.5f, 0.0f).func_181675_d();
        builder.func_227888_a_(lastMatrix, halfWidth, 0.0f, -halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(lastMatrix, halfWidth, length, -halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.0f, endV).func_181675_d();
        builder.func_227888_a_(lastMatrix, halfWidth, length, halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.5f, endV).func_181675_d();
        builder.func_227888_a_(lastMatrix, halfWidth, 0.0f, halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.5f, 0.0f).func_181675_d();
        builder.func_227888_a_(lastMatrix, -halfWidth, 0.0f, -halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(lastMatrix, -halfWidth, length, -halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.0f, endV).func_181675_d();
        builder.func_227888_a_(lastMatrix, halfWidth, length, -halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.5f, endV).func_181675_d();
        builder.func_227888_a_(lastMatrix, halfWidth, 0.0f, -halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.5f, 0.0f).func_181675_d();
        builder.func_227888_a_(lastMatrix, -halfWidth, 0.0f, halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(lastMatrix, -halfWidth, length, halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.0f, endV).func_181675_d();
        builder.func_227888_a_(lastMatrix, halfWidth, length, halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.5f, endV).func_181675_d();
        builder.func_227888_a_(lastMatrix, halfWidth, 0.0f, halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.5f, 0.0f).func_181675_d();
        builder.func_227888_a_(lastMatrix, -halfWidth, 0.0f, -halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.5f, 0.0f).func_181675_d();
        builder.func_227888_a_(lastMatrix, -halfWidth, 0.0f, halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.5f, 0.5f).func_181675_d();
        builder.func_227888_a_(lastMatrix, halfWidth, 0.0f, halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(1.0f, 0.5f).func_181675_d();
        builder.func_227888_a_(lastMatrix, halfWidth, 0.0f, -halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(lastMatrix, -halfWidth, length, -halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.5f, 0.0f).func_181675_d();
        builder.func_227888_a_(lastMatrix, -halfWidth, length, halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(0.5f, 0.5f).func_181675_d();
        builder.func_227888_a_(lastMatrix, halfWidth, length, halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(1.0f, 0.5f).func_181675_d();
        builder.func_227888_a_(lastMatrix, halfWidth, length, -halfWidth).func_225586_a_(col[0], col[1], col[2], col[3]).func_225583_a_(1.0f, 0.0f).func_181675_d();
    }

    public void func_225616_a_(T beam, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        int[] packets = ((IBeamRenderTE)beam).getRenderedBeams();
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        boolean doRotation = (Boolean)CRConfig.rotateBeam.get();
        Quaternion verticalRot = doRotation ? Vector3f.field_229181_d_.func_229187_a_(CRRenderUtil.getRenderTime(partialTicks, beam.func_145831_w()) * 2.0f) : Vector3f.field_229181_d_.func_229187_a_(45.0f);
        IVertexBuilder builder = buffer.getBuffer(CRRenderTypes.BEAM_TYPE);
        for (int dir = 0; dir < 6; ++dir) {
            if (packets[dir] == 0) continue;
            Triple<Color, Integer, Integer> trip = BeamManager.getTriple(packets[dir]);
            float width = ((Integer)trip.getRight()).floatValue() / 8.0f / (float)Math.sqrt(2.0);
            int length = (Integer)trip.getMiddle();
            matrix.func_227860_a_();
            matrix.func_227863_a_(Direction.func_82600_a((int)dir).func_229384_a_());
            matrix.func_227863_a_(verticalRot);
            BeamRenderer.drawBeam(matrix, builder, length, width, (Color)trip.getLeft());
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }

    public boolean func_188185_a(T te) {
        return true;
    }
}

